% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logreg.R
\name{logreg}
\alias{logreg}
\title{L1 Regularized Logistic Regression}
\usage{
logreg(X, y, nlambda = 50, lambda.min.ratio = 0.001, lambda = NULL,
  scale = TRUE, type = 2)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{Vector of binary observations of length equal to \code{nrow(X)}.}

\item{nlambda}{(positive integer) The number of parameters in the regularization path (default 50).}

\item{lambda.min.ratio}{(non-negative double) The ratio of \code{max(lambda) / min(lambda)} (default \code{1e-3}).}

\item{lambda}{A user-supplied vector of regularization parameters. Under the default option (\code{NULL}), the function computes a regularization path using the input data.}

\item{scale}{(boolean) Whether to scale \code{X} before running the regression. The output parameters will always be rescaled. Use \code{FALSE} if \code{X} is already scaled.}

\item{type}{(integer 1 or 2) Type 1 aggregates the input data based on repeated rows in \code{X}. Type 2 (default) uses the data as is, and is generally faster. Use Type 1 if the data contains several repeated rows.}
}
\value{
A list containing the matrix of fitted weights (\code{wmat}), the vector of regularization parameters, sorted in decreasing order (\code{lambda}), and the vector of log-likelihoods corresponding to \code{lambda} (\code{logliks}).
}
\description{
L1 Regularized logistic regression using OWL-QN L-BFGS-B optimization.
}
\examples{
# simulate some linear regression data
n <- 1e3
p <- 100
X <- matrix(rnorm(n*p),n,p)
wt <- sample(seq(0,9),p+1,replace = TRUE) / 10
z <- cbind(1,X) \%*\% wt + rnorm(n)
probs <- 1 / (1 + exp(-z))
y <- sapply(probs, function(p) rbinom(1,1,p))

m1 <- logreg(X, y)
m2 <- logreg(X, y, nlambda = 100, lambda.min.ratio = 1e-4, type = 1)

\dontrun{
# Performance comparison
library(glmnet)
library(microbenchmark)
nlambda = 50; lambda.min.ratio = 1e-3
microbenchmark(
  logreg_type1 = logreg(X, y, nlambda = nlambda,
                         lambda.min.ratio = lambda.min.ratio, type = 1),
  logreg_type2 = logreg(X, y, nlambda = nlambda,
                         lambda.min.ratio = lambda.min.ratio, type = 2),
  glmnet       = glmnet(X, y, family = "binomial",
                         nlambda = nlambda, lambda.min.ratio = lambda.min.ratio),
  times = 20L
)
}

}

