% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\name{collectIntervals}
\alias{collectIntervals}
\title{collectIntervals}
\usage{
collectIntervals(aTree)
}
\arguments{
\item{aTree}{a recursive list storing Interval object}
}
\value{
a flattened list of Interval object
}
\description{
Method for enumerating all intervals in a interval tree (a list object).
}
\examples{
i1 <- new("Interval", start=1.1, end=1.2, key="dummy1")
i2 <- new("Interval", start=-1.1, end=1.2, key="dummy2")
i3 <- new("Interval", start=-10.1, end=-1.2, key="dummy3")
i4 <- new("Interval", start=-1.1, end=1.2, key="dummy4")
i5 <- new("Interval", start=-10, end=2, key="dummy5")
i6 <- new("Interval", start=-8, end=-5, key="dummy6")
myList <- list(i1, i2, i3, i4, i5, i6)
atree <- treeFromInterval(myList)
collectIntervals(atree)
collectIntervals(list())
}
