% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yprBH_slot_func.R
\name{yprBH_slot_func}
\alias{yprBH_slot_func}
\title{Function to simulate expected yield using the Beverton-Holt Yield Per Recruit model for single input parameters}
\usage{
yprBH_slot_func(
  recruitmentTL,
  lowerSL,
  upperSL,
  cfunder,
  cfin,
  cfabove,
  cm,
  loi = NA,
  lhparms,
  matchRicker = FALSE
)
}
\arguments{
\item{recruitmentTL}{A numeric representing the minimum length limit for recruiting to the fishery in mm.}

\item{lowerSL}{A numeric representing the length of the lower slot limit in mm.}

\item{upperSL}{A numeric representing the length of the upper slot limit in mm.}

\item{cfunder}{Single value, conditional fishing mortality under the lower slot limit.}

\item{cfin}{Single value, conditional fishing mortality within the lower and upper slot limit.}

\item{cfabove}{Single value, conditional fishing mortality over the upper slot limit.}

\item{cm}{A numeric representing conditional natural mortality}

\item{loi}{A numeric vector for lengths of interest. Used to determine number of fish that reach desired lengths.}

\item{lhparms}{A named vector or list that contains values for each \code{N0}, \code{tmax}, \code{Linf}, \code{K}, \code{t0}, \code{LWalpha}, and \code{LWbeta}. See \code{\link{makeLH}} for definitions of these life history parameters. Also see details.}

\item{matchRicker}{A logical that indicates whether the yield function should match that in Ricker (). Defaults to \code{TRUE}. The only reason to changed to \code{FALSE} is to try to match output from FAMS. See the "YPR_FAMSvRICKER" article.}
}
\value{
the following calculated and input values in a data.frame
\itemize{
\item cm A numeric representing conditional natural mortality
\item TotalYield is the calculated total yield
\item TotalHarvest is the calculated total number of harvested fish
\item TotalNdie is the calculated total number of fish that die of natural death
\item yieldUnder is the calculated yield under the slot limit
\item yieldIn is the calculated yield within the slot limit
\item yieldAbove is the calculated yield above the slot limit
\item uUnder is the exploitation rate under the slot limit
\item uIn is the exploitation rate within the slot limit
\item uAbove is the exploitation rate above the slot limit
\item NharvestUnder is the number of harvested fish under the slot limit
\item NharvestIn is the number of harvested fish within the slot limit
\item NharvestAbove is the number of harvested fish above the slot limit
\item N0die is the number of fish that die of natural death before entering the fishery at a minimum length
\item NdieUnder is the number of fish that die of natural death between entering the fishery and the lower slot limit
\item NdieIn is the number of fish that die of natural deaths within the slot limit
\item NdieAbove is the number of fish that die of natural deaths above the slot limit
\item avglenUnder is the average length of fish harvested under the slot limit
\item avglenIn is the average length of fish harvested within the slot limit
\item avglenAbove is the average length of fish harvested above the slot limit
\item avgwtUnder is the average weight of fish harvested under the slot limit
\item avgwtIn is the average weight of fish harvested within the slot limit
\item avgwtAbove is the average weight of fish harvested above the slot limit
\item trUnder is the time for a fish to recruit to a minimum length limit (i.e., time to enter fishery)
\item trIn is the time for a fish to recruit to a lower length limit of the slot limit
\item trOver is the time for a fish to recruit to a upper length limit of the slot limit
\item NrUnder is the number of fish at time trUnder (time they become harvestable size under the slot limit)
\item NrIn is the number of fish at time trIn (time they reach the lower slot limit size)
\item NrAbove is the number of fish at time trAbove (time they reach the upper slot limit size)
\item FUnder is the estimated instantaneous rate of fishing mortality under the slot limit
\item FIn is the estimated instantaneous rate of fishing mortality within the slot limit
\item FAbove is the estimated instantaneous rate of fishing mortality above the slot limit
\item MUnder is the estimated  instantaneous rate of natural mortality under the slot limit
\item MIn is the estimated  instantaneous rate of natural mortality within the slot limit
\item MAbove is the estimated  instantaneous rate of natural mortality above the slot limit
\item ZUnder is the estimated  instantaneous rate of total mortality under the slot limit
\item ZIn is the estimated  instantaneous rate of total mortality within the slot limit
\item ZAbove is the estimated  instantaneous rate of total mortality above the slot limit
\item SUnder is the estimated total survival under the slot limit
\item SIn is the estimated total survival within the slot limit
\item SAbove is the estimated total survival above the slot limit
\item cfUnder A numeric representing conditional fishing mortality
\item cfIn A numeric representing conditional fishing mortality
\item cfOver A numeric representing conditional fishing mortality
\item recruitmentTL A numeric representing the minimum length limit for recruiting to the fishery in mm.
\item lowerSL A numeric representing the length of the lower slot limit in mm.
\item upperSL A numeric representing the length of the upper slot limit in mm.
\item N0 A numeric representing the initial number of new recruits entering the fishery OR a vector or list that contains named values for each \code{N0}, \code{Linf}, \code{K}, \code{t0}, \code{LWalpha}, \code{LWbeta}, and \code{tmax}
\item Linf A numeric representing the point estimate of the asymptotic mean length (L-infinity) from the von Bertalanffy growth model in mm
\item K A numeric representing the point estimate of the Brody growth coefficient from the von Bertalanffy growth model
\item t0 A numeric representing the point estimate of the x-intercept (i.e., theoretical age at a mean length of 0) from the von Bertalanffy growth model
\item LWalpha A numeric representing the point estimate of alpha from the length-weight regression on the log10 scale.
\item LWbeta A numeric representing the point estimate of beta from the length-weight regression on the log10 scale.
\item tmax An integer representing maximum age in the population in years
\item \code{N at xxx mm} is the number that reach the length of interest supplied. There will be one column for each length of interest.
#' }
}
\description{
Function to estimate yield using the Beverton-Holt YPR model. This main function accepts only single values for cf, cm, and minlength. Use the wrapper ypr() function for specifying range of cf, cm, and minlength
}
\details{
Details will be filled out later
}
\examples{
# Life history parameters to be used below
LH <- makeLH(N0=100,tmax=15,Linf=592,K=0.20,t0=-0.3,LWalpha=-5.528,LWbeta=3.273)

# Estimate yield with fixed parameters
Res_1 <- yprBH_slot_func(recruitmentTL=200,lowerSL=250,upperSL=325,
                       cfunder=0.25,cfin=0.6,cfabove=0.15,cm=0.4,
                       loi=c(200,250,300,325,350),lhparms=LH)
Res_1


}
\author{
Jason C. Doll, \email{jason.doll@fmarion.edu}
}
