% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_define.R
\name{define}
\alias{define}
\title{Apply metadata and code transformations to a data.table}
\usage{
define(
  x,
  metadata_cols = find_meta_cols(x),
  codes_cols = find_binary_cols(x),
  horizon_cols = NULL,
  units_cols = NULL
)
}
\arguments{
\item{x}{A data.table. The data.table to be transformed.}

\item{metadata_cols}{A vector of column names or NULL. A vector specifying the columns for metadata transformations.}

\item{codes_cols}{A vector of column names or NULL. A vector specifying the columns for code transformations.}

\item{horizon_cols}{A vector of column names or NULL. A vector specifying the columns for horizon transformations.}

\item{units_cols}{A vector of column names or NULL. A vector specifying the columns for unit transformations.}
}
\value{
The modified data.table after applying the metadata and code transformations.
}
\description{
This function applies metadata and code transformations to a data.table if provided.
It checks if the metadata and codes are supplied as vectors of column names.
}
\examples{
library(data.table)
dt <- data.table(a = 1:5, b = 6:10)
dt <- define(dt, metadata = c("a"), codes = c("b"))
}
