% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{write_csv}
\alias{write_csv}
\title{write_csv helper function}
\usage{
write_csv(table, filename)
}
\arguments{
\item{table}{A data.table object to store on the local file system}

\item{filename}{The file name (including the path) to store \code{table}.}
}
\value{
This function silently writes a \code{data.table} object to a CSV file.
}
\description{
Internal function to store the created tables in csv files.
}
\examples{
table <- data.table::data.table(
  a = stats::runif(1000),
  b = stats::runif(1000)
)

write_csv(table, paste0(tempdir(), "/example.csv"))

}
\seealso{
\link[data.table]{fwrite}
}
