% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\docType{methods}
\name{scp}
\alias{scp}
\alias{scp,ImmunoAssay-method}
\title{Calculate screening cut point}
\usage{
scp(
  assay.obj,
  category = NULL,
  distrib = c("normal", "nonparametric"),
  data.transf = FALSE,
  transf.method = c("log10", "ln"),
  rm.out = FALSE
)
}
\arguments{
\item{assay.obj}{An ImmunoAssay object imported by importAssay}

\item{category}{If assay.obj consists of more than 1 dataset, choose the category here to split dataset}

\item{distrib}{Distribution selection to determine the cut point calculation. Two options: 'nonparametric' or 'normal'}

\item{data.transf}{Should the data should be transformed before the cut point is calculated}

\item{transf.method}{If data.transf is TRUE, which method should be used. Can choose between 'log10' and 'ln'.}

\item{rm.out}{Should outliers be excluded from this analysis?}
}
\value{
An object of the class ImmunoAssay
}
\description{
This function will calculate the screening cut point from the melted assay.df
}
\examples{
assay.obj <- importAssay(assay.df = lognormAssay, exp.name = 'Experiment1')
assay.obj <- scp(assay.obj, category = 'Experiment1', distrib = 'normal',
data.transf = TRUE, transf.method = 'log10', rm.out = FALSE)

}
\author{
Emma Gail
}
