% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\name{excludeOutliers}
\alias{excludeOutliers}
\title{Exclude Outliers from Melted Assay Dataframe}
\usage{
excludeOutliers(
  assay.df.melted,
  data.transf = FALSE,
  transf.method = c("log10", "ln")
)
}
\arguments{
\item{assay.df.melted}{A data.frame produced by assayMelt()}

\item{data.transf}{Should the data should be transformed before normality is evaluated}

\item{transf.method}{If data.transf is TRUE, which method should be used. Can choose between 'log10' and 'ln'.}
}
\value{
A melted data.frame
}
\description{
This function excludes outliers from the assay dataframe based on grDevices::boxplot.stats(). This outlier removal method is based on Tukey's test where outliers are removed if outside the established interquartile range.
}
\examples{
assay.df.melted <- assayMelt(assay.df = lognormAssay, exp.name = 'Experiment1')
excludeOutliers(assay.df.melted, data.transf = TRUE, transf.method = 'log10')

}
\author{
Emma Gail
}
