% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.3_Taguchi_designs_Functions.R
\name{snPlot}
\alias{snPlot}
\title{snPlot: Signal-to-Noise-Ratio Plots}
\usage{
snPlot(object, type = "nominal", factors, fun = mean, response = NULL,
       points = FALSE, classic = FALSE, lty, xlab, ylab,
       main, ylim, l.col, p.col, ld.col, pch)
}
\arguments{
\item{object}{An object of class \code{\link{taguchiDesign.c}}.}

\item{type}{A character string specifying the type of the Signal-to-Noise Ratio plot. Possible values are:
\itemize{
  \item \code{`nominal`}: Nominal-the-best plot to equalize observed values to a nominal value.
  \item \code{`smaller`}: Smaller-the-better plot to minimize observed values.
  \item \code{`larger`}: Larger-the-better plot to maximize observed values.
}
Default is \code{`nominal`}.}

\item{factors}{The factors for which the effect plot is to be created.}

\item{fun}{A function for constructing the effect plot such as \code{mean}, \code{median}, etc. Default is \code{mean}.}

\item{response}{A character string specifying the response variable. If \code{object} contains multiple responses, this parameter selects one column to plot. Default is \code{NULL}.}

\item{points}{A logical value. If \code{TRUE}, points are shown in addition to values derived from \code{fun}. Default is \code{FALSE}.}

\item{classic}{A logical value. If \code{TRUE}, creates an effect plot as depicted in most textbooks. Default is \code{FALSE}.}

\item{lty}{A numeric value specifying the line type to be used.}

\item{xlab}{A title for the x-axis.}

\item{ylab}{A title for the y-axis.}

\item{main}{An overall title for the plot.}

\item{ylim}{A numeric vector of length 2 specifying the limits of the y-axis.}

\item{l.col}{A color for the lines.}

\item{p.col}{A color for the points.}

\item{ld.col}{A color for the dashed line.}

\item{pch}{The symbol for plotting points.}
}
\value{
An invisible \code{data.frame} containing all the single Signal-to-Noise Ratios.
}
\description{
Creates a Signal-to-Noise Ratio plot for designs of type \code{taguchiDesign.c} with at least two replicates.
}
\details{
The Signal-to-Noise Ratio (SNR) is calculated based on the type specified:
\itemize{
  \item \code{`nominal`}: \deqn{SN = 10 \cdot log(mean(y) / var(y))}
  \item \code{`smaller`}: \deqn{SN = -10 \cdot log((1 / n) \cdot  sum(y^2))}
  \item \code{`larger`}: \deqn{SN = -10 \cdot log((1 / n) \cdot sum(1 / y^2))}
}
Signal-to-Noise Ratio plots are used to estimate the effects of individual factors and to judge the variance and validity of results from an effect plot.
}
\examples{
tdo <- taguchiDesign("L9_3", replicates = 3)
tdo$.response(rnorm(27))
snPlot(tdo, points = TRUE, l.col = 2, p.col = 2, ld.col = 2, pch = 16, lty = 3)
}
