% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{normalPlot}
\alias{normalPlot}
\title{normalPlot: Normal plot}
\usage{
normalPlot(
  dfac,
  response = NULL,
  main,
  ylim,
  xlim,
  xlab,
  ylab,
  pch,
  col,
  border = "red"
)
}
\arguments{
\item{dfac}{An object of class \code{\link{facDesign.c}}.}

\item{response}{Response variable. If the response data frame of fdo consists of more then one responses, this variable can be used to choose just one column of the \code{response} data frame. response needs to be an object of class character with length of `1`. It needs to be the same character as the name of the response in the response data frame that should be plotted.
By default \code{respons}` is set to \code{NULL}.}

\item{main}{Character string specifying the main title of the plot.}

\item{ylim}{Graphical parameter. The y limits of the plot.}

\item{xlim}{Graphical parameter. The x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a `reversed axis`.}

\item{xlab}{Character string specifying the label for the x-axis.}

\item{ylab}{Character string specifying the label for the y-axis.}

\item{pch}{Graphical parameter. Vector containing numerical values or single characters giving plotting points for the different factors.
Accepts values from 0 to 25, each corresponding to a specific shape in \code{ggplot2} (e.g., 0: square, 1: circle, 2: triangle point up, 3: plus, 4: cross).}

\item{col}{Graphical parameter. Single numerical value or character string giving the color for the points (e.g., 1: black, 2: red, 3: green).}

\item{border}{Graphical parameter. Single numerical value or character string giving the color of the border line.}
}
\value{
The function \code{normalPlot} returns an invisible list containing:
\item{effects}{a list of effects for each response in the \code{facDesign.c} object.}
\item{plot}{The generated normal plot.}
}
\description{
Creates a normal probability plot for the effects in a \code{\link{facDesign.c}} object.
}
\details{
If the given \code{facDesign.c} object \code{fdo} contains replicates this function will deliver a normal plot
i.e.: effects divided by the standard deviation (t-value) will be plotted against an appropriate probability
scaling (see: `ppoints`).
If the given \code{facDesign.c} object \code{fdo} contains no replications the standard error can not be calculated.
In that case the function will deliver an effect plot.
i.e.: the effects will be plotted against an appropriate probability scaling. (see: `ppoints`).
}
\examples{
# Example 1: Create a normal probability plot for a full factorial design
dfac <- facDesign(k = 3, centerCube = 4)
dfac$names(c('Factor 1', 'Factor 2', 'Factor 3'))

# Assign performance to the factorial design
rend <- c(simProc(120,140,1), simProc(80,140,1), simProc(120,140,2),
          simProc(120,120,1), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(80,120,2), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(120,120,2), simProc(80,140,2), simProc(80,120,1))
dfac$.response(rend)

normalPlot(dfac)

# Example 2: Create a normal probability plot with custom colors and symbols
normalPlot(dfac, col = "blue", pch = 4)
}
\seealso{
\code{\link{facDesign}}, \code{\link{paretoPlot}}, \code{\link{interactionPlot}}
}
