% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_increment.R
\name{file_increment}
\alias{file_increment}
\title{Rename Stock Synthesis files by adding integer value}
\usage{
file_increment(
  i,
  verbose = FALSE,
  pattern = "^[CcPRw][a-zA-Z]+\\\\.sso|summary\\\\.sso|\\\\.par$"
)
}
\arguments{
\item{i}{An integer value to append to the file name before the
\code{.sso} extension.}

\item{verbose}{A logical value specifying if output should be printed
to the screen.}

\item{pattern}{A character value specifying the file names to search
for in \code{getwd()}.}
}
\value{
Invisibly returns a vector of logical values specifying
whether or not the file was successfully renamed.
}
\description{
Rename files found with \code{pattern} by adding \code{i} to their
name before the extension.
}
\details{
The \code{.par} file, which is the only file extension searched for
with the default entry that does not end in \code{.sso}, is
modified differently.\verb{_i.sso} is added to the file name.
}
\author{
Kelli F. Johnson
}
