% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{m_style_cartoon}
\alias{m_style_cartoon}
\title{Specify Styling for Cartoon}
\usage{
m_style_cartoon(
  color = NULL,
  style = "rectangle",
  ribbon = FALSE,
  arrows = TRUE,
  tubes = FALSE,
  thickness = 0.4,
  width = NULL,
  opacity = 1,
  colorfunc = NULL
)
}
\arguments{
\item{color}{Block color values. Strand color, may specify as 'spectrum'
which will apply
reversed gradient based on residue number.}

\item{style}{style of cartoon rendering ("trace", "oval", "rectangle"
(default), "parabola", "edged").}

\item{ribbon}{whether to use constant strand width, disregarding secondary
structure; use thickness to adjust radius.}

\item{arrows}{whether to add arrows showing beta-sheet directionality;
does not apply to trace or ribbon.}

\item{tubes}{whether to display alpha helices as simple cylinders; does not
apply to trace.}

\item{thickness}{cartoon strand thickness, default is 0.4.}

\item{width}{cartoon strand width, default is secondary structure-dependent;
does not apply to trace or ribbon.}

\item{opacity}{set opacity from 0-1; transparency is set per-chain with a
warning outputted in the event of ambiguity.}

\item{colorfunc}{Allows the user to provide a function for setting the
colorSchemes, written in javascript.
\href{https://3dmol.csb.pitt.edu/doc/types.html#CartoonStyleSpec}{Official
Documentation}}
}
\description{
Styling options for the cartoon representation. Used inside
\code{m_add_style()} and \code{m_set_style()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = m_style_cartoon(color = "spectrum")) \%>\%
  m_zoom_to()
}
