% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r3dmol.R
\name{init}
\alias{init}
\alias{r3dmol}
\title{Initialise a WebGL-based viewer}
\usage{
r3dmol(
  id = NULL,
  viewer_spec = m_viewer_spec(),
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{id}{HTML element id of viewer.}

\item{viewer_spec}{Some useful viewer input specifications. Additional
options pass in via ... will override options set in viewer_spec.}

\item{...}{Additional, more niche viewer input specification, see
\url{http://3dmol.csb.pitt.edu/doc/types.html#ViewerSpec}
for more details.}

\item{width}{Fixed width for viewer (in css units). Ignored when used in a
Shiny app -- use the \code{width} parameter in
\code{\link[r3dmol]{r3dmolOutput}}.
It is not recommended to use this parameter because the widget knows how to
adjust its width automatically.}

\item{height}{Fixed height for viewer (in css units). It is recommended to
not use this parameter since the widget knows how to adjust its height
automatically.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Ignored when used in a Shiny app.}
}
\description{
Create and initialize an appropriate viewer at supplied HTML element using
specification in config
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_zoom_to()

# Viewer configs setting
r3dmol(
  backgroundColor = "black",
  lowerZoomLimit = 1,
  upperZoomLimit = 350
) \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_zoom_to()
}
