% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socialtools.R
\name{socialButtons}
\alias{socialButtons}
\title{Customizable social icons}
\usage{
socialButtons(
  link,
  type = c("share", "connect"),
  image = NULL,
  text = NULL,
  plain = FALSE,
  position = c("left", "right", "inline"),
  text.color = "white",
  bg.col = NULL,
  facebook = FALSE,
  linkedin = FALSE,
  x = FALSE,
  tumblr = FALSE,
  pinterest = FALSE,
  whatsapp = FALSE,
  reddit = FALSE,
  instagram = FALSE,
  blogger = FALSE,
  weibo = FALSE,
  tiktok = FALSE,
  vk = FALSE,
  baidu = FALSE,
  telegram = FALSE,
  youtube = FALSE,
  visit.us = FALSE,
  link.out = FALSE
)
}
\arguments{
\item{link}{link address to share}

\item{type}{type of social button e.g. share or connect}

\item{image}{image link for pinterest only}

\item{text}{text link for x only}

\item{plain}{logical. with or without background}

\item{position}{position of buttons e.g "left","right","bottom","inline"}

\item{text.color}{text color}

\item{bg.col}{background color for the icons.}

\item{facebook}{share on Facebook}

\item{linkedin}{share on Linkedin}

\item{x}{share on Twitter}

\item{tumblr}{share on Tumblr}

\item{pinterest}{share on Pinterest}

\item{whatsapp}{share on Whatsapp}

\item{reddit}{share on Reddit}

\item{instagram}{share on Instagram}

\item{blogger}{share on Blogger}

\item{weibo}{share on Weibo}

\item{tiktok}{share on Tiktok}

\item{vk}{share on VK or VKontakte}

\item{baidu}{share on Baidu}

\item{telegram}{share on Telegram}

\item{youtube}{share on Youtube}

\item{visit.us}{visit a direct link}

\item{link.out}{hyperlink to a page}
}
\value{
Social links button to be placed on pages
}
\description{
For use in making buttons to share a page or connect to your social media
}
\note{
'bg.col' argument is only functional if 'plain' argument is set to false
}
\section{Examples for r2social}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2social}.
}

\examples{
# styled
socialButtons("https://shinyappstore.com/",facebook = TRUE)

# plain
socialButtons("https://shinyappstore.com/",plain=TRUE, linkedin = TRUE)

}
