% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qable.R
\name{qable}
\alias{qable}
\title{Qable: an extended version of knitr::kable}
\usage{
qable(
  x,
  rtitle = "",
  rgroup = numeric(0),
  rnames = rownames(x),
  cnames = colnames(x),
  markup = getOption("qwraps2_markup", "latex"),
  kable_args = list(),
  ...
)
}
\arguments{
\item{x}{\code{matrix} or \code{data.frame} to be turned into a qable}

\item{rtitle}{a row grouping title. See Details.}

\item{rgroup}{a named numeric vector with the name of the row group and the
number of rows within the group.  \code{sum(rowgroup) == nrow(x)}.}

\item{rnames}{a character vector of the row names}

\item{cnames}{column names}

\item{markup}{the markup language to use expected to be either "markdown" or
"latex"}

\item{kable_args}{a list of named arguments to send to
\code{\link[knitr]{kable}}.  See Details.}

\item{...}{pass through}
}
\value{
\code{qable} returns a \code{qwraps2_qable} object that is just a character matrix with
some additional attributes and the print method returns, invisibly, the
object passed to print.
}
\description{
Create a simple table via \code{\link[knitr]{kable}} with row
groups and rownames similar to those of \code{\link[Hmisc]{latex}} from the
Hmisc package or \code{\link[htmlTable]{htmlTable}} from the htmlTable
package.
}
\details{
\code{rtitle} can be used to add a title to the column constructed by the
\code{rgroup} and \code{rnames}.  The basic layout of a table generated by
\code{qable} is:

\tabular{lcc}{
 rtitle    \tab cnames[1] \tab cnames[2] \cr
 rgroup[1] \tab           \tab           \cr
 rnames[1] \tab x[1, 1]   \tab x[1, 2]   \cr
 rnames[2] \tab x[2, 1]   \tab x[2, 2]   \cr
 rnames[3] \tab x[3, 1]   \tab x[3, 2]   \cr
 rgroup[2] \tab           \tab           \cr
 rnames[4] \tab x[4, 1]   \tab x[4, 1]   \cr
 rnames[5] \tab x[5, 1]   \tab x[5, 1]   \cr
}

Passing arguments to \code{link[knitr]{kable}} is done via the list
\code{kable_args}.  This is an improvement in 0.6.0 to address arguments with
different use between qable and kable but the same name, notably
\code{format}.  Within the print method for \code{qwraps2_qable} objects,
some default arguments for knitr::kable are created.

Defaults if the named element of \code{kable_args} is missing:
\code{kable_args$format} will be "latex" if \code{markup = "latex"} and will
be \code{"pipe"} if \code{markup = "markdown"}.

\code{kable_args$escape = !(markup = "latex")}

\code{kable_args$row.names} defaults to \code{FALSE}

\code{kable_args$col.names} defaults to \code{colnames(x)}
}
\examples{
data(mtcars)
x <- qable(mtcars)
x
qable(mtcars, markup = "markdown")

# by make
make <- sub("^(\\\\w+)\\\\s?(.*)$", "\\\\1", rownames(mtcars))
make <- c(table(make))

# A LaTeX table with a vertical bar between each column
qable(mtcars[sort(rownames(mtcars)), ], rgroup = make)

# A LaTeX table with no vertical bars between columns
qable(mtcars[sort(rownames(mtcars)), ], rgroup = make, kable_args = list(vline = ""))

# a markdown table
qable(mtcars[sort(rownames(mtcars)), ], rgroup = make, markup = "markdown")

# define your own column names
qable(mtcars[sort(rownames(mtcars)), ],
      rgroup = make,
      cnames = toupper(colnames(mtcars)),
      markup = "markdown")

# define your own column names and add a title
qable(mtcars[sort(rownames(mtcars)), ],
      rtitle = "Make & Model",
      rgroup = make,
      cnames = toupper(colnames(mtcars)),
      markup = "markdown")

}
\seealso{
\code{\link[knitr]{kable}}

\code{\link{summary_table}}, for an example of build a data summary table.

For more detail on arguments you can pass via \code{kable_args} look at the
non-exported functions form the knitr package \code{knitr:::kable_latex},
\code{knitr:::kable_markdown}, or others.
}
