% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_evolution.R
\name{unitary_matrix.ctqwalk}
\alias{unitary_matrix.ctqwalk}
\title{The Unitary Time Evolution Operator of a Continuous-Time Quantum Walk}
\usage{
\method{unitary_matrix}{ctqwalk}(object, t, ...)
}
\arguments{
\item{object}{an instance of class \code{ctqwalk}.}

\item{t}{it will be returned the evolution operator at time \code{t}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{unitary_matrix()} returns the unitary time evolution operator of the
CTQW evaluated at time \code{t}.
}
\description{
The Unitary Time Evolution Operator of a Continuous-Time Quantum Walk
}
\details{
If \eqn{|\psi(t) \rangle} is the quantum state of the system at time \eqn{t}, and
\eqn{H} the Hamiltonian operator, then the evolution is governed by
the Schrodinger equation

\deqn{\frac{\partial}{\partial t}|\psi(t) \rangle = iH|\psi(t) \rangle}

and if \eqn{H} is time-independent its solution is given by

\deqn{|\psi(t) \rangle = U(t)|\psi(0) \rangle = e^{iHt}|\psi(0) \rangle}

The evolution operator is the result of the complex matrix exponential
and it can be calculated as

\deqn{U(t) = e^{iHt} = \sum_r e^{i t \lambda_r}E_r}

in which \eqn{H = \sum_r \lambda_r E_r}.
}
\examples{
walk <- ctqwalk(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))

# Returns the operator at time t = 2*pi, U(2pi)
unitary_matrix(walk, t = 2*pi)

}
\seealso{
\code{\link[=ctqwalk]{ctqwalk()}}, \code{\link[=unitary_matrix]{unitary_matrix()}},
\code{\link[=act_eigfun]{act_eigfun()}}
}
