% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_evolution.R
\name{mixing_matrix.ctqwalk}
\alias{mixing_matrix.ctqwalk}
\title{The Mixing Matrix of a Continuous-Time Quantum Walk}
\usage{
\method{mixing_matrix}{ctqwalk}(object, t, ...)
}
\arguments{
\item{object}{an instance of class \code{ctqwalk}.}

\item{t}{it will be returned the mixing matrix at time \code{t}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{mixing_matrix()} returns the  mixing matrix of the CTQW
evaluated at time \code{t}.
}
\description{
The Mixing Matrix of a Continuous-Time Quantum Walk
}
\details{
Let \eqn{U(t)} be the time evolution operator of the quantum walk at
time \eqn{t}, then the mixing matrix is given by

\deqn{M(t) = U(t) \circ \overline{U(t)}}

\eqn{M(t)} is a doubly stochastic real symmetric matrix, which encodes the
probability density of the quantum system at time \eqn{t}.

More precisely, the \eqn{(M(t))_{ab}} entry gives us the probability
of measuring the standard basis state \eqn{|b \rangle} at time \eqn{t}, given that
the quantum walk started at \eqn{|a \rangle}.
}
\examples{
walk <- ctqwalk(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))

# Returns the mixing matrix at time t = 2*pi, M(2pi)
mixing_matrix(walk, t = 2*pi)

}
\seealso{
\code{\link[=ctqwalk]{ctqwalk()}}, \code{\link[=mixing_matrix]{mixing_matrix()}}
}
