% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phen_hiv.R
\name{phen_hiv}
\alias{phen_hiv}
\title{Calculate Final State and Payoffs in Quantum Game}
\usage{
phen_hiv(strategy1, strategy2, alpha, beta, gamma, theta)
}
\arguments{
\item{strategy1}{A 2x2 matrix representing the strategy of player 1.}

\item{strategy2}{A 2x2 matrix representing the strategy of player 2.}

\item{alpha}{A numeric value representing the payoff for outcome |00>.}

\item{beta}{A numeric value representing the payoff for outcome |01>.}

\item{gamma}{A numeric value representing the payoff for outcome |10>.}

\item{theta}{A numeric value representing the payoff for outcome |11>.}
}
\description{
This function calculates the final quantum state and expected payoffs for two
players in a quantum game based on their strategies. The function uses quantum
gates and unitary transformations to simulate the game dynamics.
}
\examples{
strategy1 <- diag(2) # Identity matrix for strategy 1
strategy2 <- diag(2) # Identity matrix for strategy 2
alpha <- 1
beta <- 0.5
gamma <- 2
theta <- 0.1
result <- phen_hiv(strategy1, strategy2, alpha, beta, gamma, theta)

}
\references{
Özlüer Başer, B. (2022). "Analyzing the competition of HIV-1 phenotypes with quantum game theory".
Gazi University Journal of Science, 35(3), 1190--1198. \doi{10.35378/gujs.772616}
}
