% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.InteractionClassification.R,
%   R/mse.payoffs.R
\name{mse}
\alias{mse}
\title{Mean Squared Errors for Interaction Classification}
\usage{
mse(object, ...)

mse(object, ...)
}
\arguments{
\item{object}{An object of class \code{payoffs}.}

\item{...}{Additional arguments passed to other methods (currently not used).}
}
\value{
A \code{data.frame} containing the MSE for CD4 count differences (\code{mse_cds_diff})
and (\code{mse_vlogs_diff}) for viral load differences.
}
\description{
Mean squared errors (MSE) for viral load differences
and CD4 count differences by comparing the actual values with the group means
from the classification.

Computes the mean squared error (MSE) between observed CD4 and viral load differences
and their corresponding predicted payoff values within each interaction classification.
}
\examples{
set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
mse(result)

set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
data(preds)
payoffs_results <- estimate_payoffs(result, preds)
mse(payoffs_results)

}
