% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.sb.R
\name{crossq.sb}
\alias{crossq.sb}
\title{Stationary Bootstrap for the Cross-Quantilogram}
\usage{
crossq.sb(DATA, vecA, k, gamma, Bsize, sigLev)
}
\arguments{
\item{DATA}{An input matrix of dimensions T x 2, where T is the number of observations.
Column 1 contains the first variable and Column 2 contains the second variable.
This function will apply a k-period lag to the second variable during computation.}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order}

\item{gamma}{A parameter for the stationary bootstrap}

\item{Bsize}{The number of repetition of bootstrap}

\item{sigLev}{The statistical significance level}
}
\value{
The boostrap critical values
}
\description{
Returns critical values for the cross-quantilogram, based on the stationary bootstrap.
}
\details{
This function generates critical values for for the cross-quantilogram,
using the stationary bootstrap in Politis and Romano (1994).
}
\examples{
data("sys.risk") ## data source
D = sys.risk[,c("Market", "JPM")] ## data: 2 variables

# probability levels for the 2 variables
vecA = c(0.1, 0.5)

## setup for stationary bootstrap
gamma  = 1/10 ## bootstrap parameter depending on data
Bsize  = 5    ## small size, 5, for test 
sigLev = 0.05 ## significance level

## cross-quantilogram with the lag of 5
crossq.sb(D, vecA, 5, gamma, Bsize, sigLev)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series."
\emph{Journal of Econometrics}, 193(1), 251-270.

Politis, Dimitris N., and Joseph P. Romano. "The stationary bootstrap." \emph{Journal of the American Statistical Association} 89.428 (1994): 1303-1313.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
