% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCurv.R
\name{locNormLinData}
\alias{locNormLinData}
\title{Centile curves using local linear polynomial compared to noise data}
\usage{
locNormLinData(
  x,
  y,
  bandwidth.method,
  cents = c(0.03, 0.25, 0.5, 0.75, 0.97),
  data,
  leg = FALSE
)
}
\arguments{
\item{x}{the explanatory variable - numeric}

\item{y}{the response variable - numeric}

\item{bandwidth.method}{the method chosen to calculate bandwidth. Could be cross validation or Plug-in. Default is set to CV.}

\item{cents}{A numeric vector that represents the centiles calculated. Default is set to cents=c(0.03,0.25,0.5,0.75,0.97))}

\item{data}{the noise data we want to compare}

\item{leg}{Boolean. Should the legend be desplayed (TRUE) or not (FALSE).}
}
\value{
Plots centile curves with local linear polynomial using a Gaussian kernel and displays them on the same figure as the noise data to be compared
}
\description{
Centile curves using local linear polynomial compared to noise data
}
\examples{
#create a sample data frame
sample<-data.frame(sample(30:42,50,rep=TRUE),sample(800:5000,50,rep=TRUE))
colnames(sample)<-c("Gestational Age in weeks","Weight in gramms")
x<-sample$`Gestational Age in weeks`
y<-sample$`Weight in gramms`
abnormal<-data.frame(sample(30:42,10,rep=TRUE),sample(800:5000,10,rep=TRUE))
colnames(abnormal)<-c("Gestational Age in weeks","Weight in gramms")
locNormLinData(x,y,bandwidth.method="Plug-in",cents=c(0.03,0.25,0.50,0.75,0.97),data=abnormal)


}
