% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisepoly2D.R
\name{noisepoly2D}
\alias{noisepoly2D}
\title{Polynomial estimation of the image noise.}
\usage{
noisepoly2D(object, gd = 20, power = 5, col = "green")
}
\arguments{
\item{object}{S3 object of the working TLC}

\item{gd}{Defines position of the center of the rectangular samples of the image background (above or bellow located spots).}

\item{power}{Order of the polynome.}

\item{col}{Color of the borders of the rectangles for bkg samples.}
}
\value{
Returns S3 object with new variables. \item{object$noise_mat}{The 3D matrix (width, height, number of spots)} \item{object$noise_fit}{Linear model for the polynomial fit} \item{object$noisefit_spot_sums}{Sums of the noise samples areas}
}
\description{
Estimation, and noise removal using polynomial model.
}
\examples{
\dontrun{
#object is a tlc with 14 spots, and selection 50x80(wxh)
object <- noisepoly2D(object, gd=80, power=13)
}

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}

