% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_scan1.R
\name{cbind.scan1}
\alias{cbind.scan1}
\title{Join genome scan results for different phenotypes.}
\usage{
\method{cbind}{scan1}(...)
}
\arguments{
\item{...}{Genome scan objects of class \code{"scan1"}, as produced by \code{\link[=scan1]{scan1()}}.
Must have the same map.}
}
\value{
An object of class `"scan1", like the inputs, but with the lod score columns
from the inputs combined as multiple columns in a single object.
}
\description{
Join multiple \code{\link[=scan1]{scan1()}} results for different phenotypes;
must have the same map.
}
\details{
If components \code{addcovar()}, \code{Xcovar},
\code{intcovar}, \code{weights} do not match between objects, we
omit this information.

If \code{hsq} present but has differing numbers of rows, we omit this information.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probs <- calc_genoprob(grav2, map, error_prob=0.002)
phe1 <- grav2$pheno[,1,drop=FALSE]
phe2 <- grav2$pheno[,2,drop=FALSE]

out1 <- scan1(probs, phe1) # phenotype 1
out2 <- scan1(probs, phe2) # phenotype 2
out <- cbind(out1, out2)

}
\seealso{
\code{\link[=rbind.scan1]{rbind.scan1()}}, \code{\link[=scan1]{scan1()}}
}
