% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groebner.R
\name{isPolynomialOf}
\alias{isPolynomialOf}
\title{Whether a 'qspray' is a polynomial of some given 'qsprays'}
\usage{
isPolynomialOf(qspray, qsprays)
}
\arguments{
\item{qspray}{a \code{qspray} object}

\item{qsprays}{a list of \code{qspray} objects}
}
\value{
A Boolean value indicating whether the polynomial defined by 
  \code{qspray} can be written as a polynomial of the polynomials defined 
  by the \code{qspray} objects given in the \code{qsprays} list. If this is 
  \code{TRUE}, this polynomial is returned as an attribute named 
  \code{"polynomial"}.
}
\description{
Checks whether a \code{qspray} polynomial can be written as 
  a polynomial of some given \code{qspray} polynomials. If \code{TRUE}, 
  this polynomial is returned.
}
\examples{
library(qspray)
x <- qlone(1); y <- qlone(2); z <- qlone(3)
q1 <- x + y
q2 <- x*z^2 + 4
qspray <- q1^2*q2 + 2*q1 + 3
( check <- isPolynomialOf(qspray, list(q1, q2)) )
POLYNOMIAL <- attr(check, "polynomial")
changeVariables(POLYNOMIAL, list(q1, q2)) == qspray # should be TRUE
}
