% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_new_functions.R
\name{create_label}
\alias{create_label}
\title{Create custom machine- and human-readable rectangular plot labels}
\usage{
create_label(
  wdt = 2,
  hgt = 1,
  page_wdt = 8.5,
  page_hgt = 11,
  top_mar = 0.625,
  bot_mar = 0.625,
  left_mar = 0.625,
  right_mar = 0.625,
  numrow = 8L,
  numcol = 3L,
  filename = "PlotLabel",
  font_sz = 8,
  Treetag = FALSE,
  family = "sans",
  rounded = TRUE,
  print_across = TRUE,
  rect = TRUE,
  top_left_1 = NULL,
  top_left_2 = NULL,
  top_right_1 = NULL,
  top_right_2 = NULL,
  center_right_1 = NULL,
  center_right_2 = NULL,
  center_right_3 = NULL,
  bottom_left_1 = NULL,
  bottom_left_2 = NULL,
  unique_id = NULL,
  include_qr = TRUE,
  ec_level = 3,
  ...
)
}
\arguments{
\item{wdt}{The label width in inches.}

\item{hgt}{The label height in inches.}

\item{page_wdt}{The page width in inches.}

\item{page_hgt}{The page height in inches.}

\item{top_mar}{The page top margin in inches.}

\item{bot_mar}{The page bottom margin in inches.}

\item{left_mar}{The page left margin in inches.}

\item{right_mar}{The page right margin in inches.}

\item{numrow}{The number of label rows per page. It should be an integer.}

\item{numcol}{The number of label columns per page. It should be an integer.}

\item{filename}{A character prefix or path for the pdf file to be created. Default path
is working directory.}

\item{font_sz}{The font size to use.}

\item{Treetag}{Set to TRUE if creating a treetag label.}

\item{family}{The font style to use to print labels.}

\item{rounded}{Set to TRUE if label has round corners; set to false if label has
square corners.}

\item{print_across}{Set to TRUE to print labels across rows, left to right; else 
set to FALSE to print labels down columns, top to bottom. Default is \code{TRUE}.}

\item{rect}{Set to TRUE to draw rectangles around labels, else set to FALSE. 
Default is \code{TRUE}.}

\item{top_left_1}{String for top-left row 1 position on a rectangular label.}

\item{top_left_2}{String for top-left row 2 position on a rectangular label.}

\item{top_right_1}{String for top-right row 1 position on a rectangular label.}

\item{top_right_2}{String for top-right row 2 position on a rectangular label.}

\item{center_right_1}{String for center-right row 1 position on a rectangular label.}

\item{center_right_2}{String for center-right row 2 position on a rectangular label.}

\item{center_right_3}{String for center-right row 3 position on a rectangular label.}

\item{bottom_left_1}{String for bottom-left row 1 position on a rectangular label.}

\item{bottom_left_2}{String for bottom-left row 2 position on a rectangular label.}

\item{unique_id}{A vector containing unique identifiers or strings to generate QR codes.}

\item{include_qr}{Logical. Set to FALSE to exclude QR codes. Default is TRUE.}

\item{ec_level}{The error correction level (`0` - `3`, lowest to highest) for QR codes.}

\item{...}{Additional optional arguments to be supplied.}
}
\value{
A PDF file containing experimental plot labels affixed with QR codes, saved to the default or working directory.
}
\description{
Create print-ready customized plot labels affixed with QR codes given the page setup,
 label dimensions, the number of rows and columns of labels to print per page.
}
\examples{
library(qrlabelr)
file <- tempfile()
\donttest{
if(file.exists(file)) 
# Create rectangular plot labels based on the Avery 94220 template-- the default template
create_label(
font_sz = 10,
filename = file, 
print_across = TRUE,
rect = TRUE,
top_left_1 = paste("Plot:", 101:105), 
top_left_2 = paste("Row:", c(rep(1, 3), rep(2, 2))), 
top_right_1 = paste("Rep:", rep(1, 5)), 
top_right_2 = paste("Col:", c(1:3, 1:2)), 
center_right_1 = paste("iBLOCK:", c(rep(1, 3), rep(2, 2))), 
center_right_2 = paste("Seed:", rep("OFF_NUR", 5)), 
center_right_3 = rep("AWk", 5), 
bottom_left_1 = paste("Loc:", rep("BAMBEY", 5)), 
bottom_left_2 = paste0("G-", 1:5),
unique_id = paste("KUMASI2023_PYT", c(101:105), 
                  c(rep(1, 3), rep(2, 2)), c(1:3, 1:2),
                  sep = "_"), 
ec_level = 1)
}



}
\seealso{
\code{\link{field_label}} and \code{\link{gp_label}}
}
