
test_that("General-purpose plot label PDF successful generation", {
  #skip_on_cran()
  
  path <- tempdir()
  setwd(path)
  
  expect_invisible(
    gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                              PLOT = 1001:1010, 
                              ROW = c(rep(1, 6), rep(2, 4)),
                              COLUMN = c(1:6, 1:4),
                              REP = rep(1, 10),
                              IBLOCK = c(rep(1, 6), rep(2, 4)),
                              TREATMENT = paste0("G-", 1:10),
                              SEED_SOURCE = rep("OFF_NUR", 10)),
                               wdt = 5, 
                               hgt = 2,
                               page_wdt = 8.5, 
                               page_hgt = 11,
                               top_mar = 0.75, 
                               bot_mar = 0.75, 
                               left_mar = 1.75, 
                               right_mar = 1.75, 
                               numrow = 4L, 
                               numcol = 1L, 
                               get_unique_id = "uuid",
                               filename = "PlotLabel", 
                               font_sz = 20, 
                               top_left_txt1 = 'Plot:',
                               top_left_txt2 = 'Row:', 
                               top_right_txt1 = 'Rep:',
                               top_right_txt2 = 'Col:',
                               center_right_txt1 = 'iBlock ID:',
                               center_right_txt2 = 'Seed:',
                               center_right_txt3 = 'AWK',
                               bottom_left_txt1 = 'Loc:',
                               top_left_id1 = 'PLOT',
                               top_left_id2 = 'ROW',
                               top_right_id1 = 'REP',
                               top_right_id2 = 'COLUMN',
                               center_right_id1 = 'IBLOCK',
                               center_right_id2 = 'SEED_SOURCE',
                               bottom_left_id1 = 'LOCATION',
                               bottom_left_id2 = 'TREATMENT'))
  
  expect_true(length(list.files(path = ".", pattern = "\\.pdf$")) > 0)
  expect_true(length(list.files(path = ".", pattern = "\\.csv$")) > 0)
  
  on.exit(unlink(path))
})


test_that("General-purpose plot label input errors", {
  
  #skip_on_cran()
  
  expect_error(gp_label(font_sz = 10,
                           get_unique_id = "uuid",
                           filename = "PlotLabel", 
                        
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT'), 
               "Fieldbook is missing, please provide a fieldbook as a data frame.")
  
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        wdt = 5, 
                        hgt = 2,
                        page_wdt = 8.5, 
                        page_hgt = 11,
                        top_mar = 2, 
                        bot_mar = 2, 
                        left_mar = 4, 
                        right_mar = 4, 
                        numrow = 4L, 
                        numcol = 1L, 
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ), 
               "Page setup does not match label setup per page.")
  
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                           get_unique_id = "uuid",
                           filename = "PlotLabel", 
                           font_sz = 10, 
                           top_left_txt1 = 'Plot:',
                           top_left_txt2 = 'Row:', 
                           top_right_txt1 = 'Rep:',
                           top_right_txt2 = 'Col:',
                           center_right_txt1 = 'iBlock ID:',
                           center_right_txt2 = 'Seed:',
                           center_right_txt3 = 'AWK',
                           bottom_left_txt1 = 'Loc:',
                           top_left_id1 = 1,
                           top_left_id2 = 'ROW',
                           top_right_id1 = 'REP',
                           top_right_id2 = 'COLUMN',
                           center_right_id1 = 'IBLOCK',
                           center_right_id2 = 'SEED_SOURCE',
                           bottom_left_id1 = 'LOCATION',
                           bottom_left_id2 = 'TREATMENT'),
               "Invalid string entered for 'top_left_id1'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 1,
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'top_left_id2'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 1,
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'top_right_id1'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 1,
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'top_right_id2'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 1,
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'center_right_id1'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 1,
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'center_right_id2'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 1,
                        bottom_left_id2 = 'TREATMENT' ),
               "Invalid string entered for 'bottom_left_id1'")
  
  expect_error(gp_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                         PLOT = 1001:1010, 
                                         ROW = c(rep(1, 6), rep(2, 4)),
                                         COLUMN = c(1:6, 1:4),
                                         REP = rep(1, 10),
                                         IBLOCK = c(rep(1, 6), rep(2, 4)),
                                         TREATMENT = paste0("G-", 1:10),
                                         SEED_SOURCE = rep("OFF_NUR", 10)),
                        
                        get_unique_id = "uuid",
                        filename = "PlotLabel", 
                        font_sz = 10, 
                        top_left_txt1 = 'Plot:',
                        top_left_txt2 = 'Row:', 
                        top_right_txt1 = 'Rep:',
                        top_right_txt2 = 'Col:',
                        center_right_txt1 = 'iBlock ID:',
                        center_right_txt2 = 'Seed:',
                        center_right_txt3 = 'AWK',
                        bottom_left_txt1 = 'Loc:',
                        top_left_id1 = 'PLOT',
                        top_left_id2 = 'ROW',
                        top_right_id1 = 'REP',
                        top_right_id2 = 'COLUMN',
                        center_right_id1 = 'IBLOCK',
                        center_right_id2 = 'SEED_SOURCE',
                        bottom_left_id1 = 'LOCATION',
                        bottom_left_id2 = 1 ),
               "Invalid string entered for 'bottom_left_id2'")
  
})