% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqslider.R
\name{side_by_side_slider}
\alias{side_by_side_slider}
\title{Side-by-side Slider}
\usage{
side_by_side_slider(name, dists = make_df_list())
}
\arguments{
\item{name}{Name of distribution to contrast with normal}

\item{dists}{Named list of (d=density, q=quantile, r=sample) distributions (see make_df_list())}
}
\value{
None
}
\description{
Opens the default web browser with a display of two continuous distributions
shown side-by-side and reflected to suggest a closed container.
Interactive options control the display of water levels and the choice of
the shapes of the underlying distributions.
}
\examples{
\dontrun{
side_by_side_slider("Gamma")

dists <- make_df_list()
dists[["uniform"]] <- list(d=dunif, q=qunif, r=runif);
side_by_side_slider("uniform", dists)
}
}

