% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPFISHbMDD.R
\name{CPFISH.bMDD}
\alias{CPFISH.bMDD}
\title{CPFISH bootstrap MDD (bMDD)}
\usage{
CPFISH.bMDD(
  contingency.table,
  control.name = NULL,
  alpha = 0.05,
  shift.step = -0.01,
  bootstrap.runs = 200,
  power = 0.8,
  max.iterations = 1000,
  simulate.p.value = TRUE,
  use.fixed.random.seed = NULL,
  show.progress = TRUE,
  show.results = TRUE
)
}
\arguments{
\item{contingency.table}{Matrix with observed data (e.g. survival counts, survival must be in first row)}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{shift.step}{Step of shift (negative as a reduction is assumed)}

\item{bootstrap.runs}{Number of bootstrap runs (draw Poisson data n times)}

\item{power}{Proportion of bootstrap.runs that return significant differences}

\item{max.iterations}{Max. number of iterations to not get stuck in the while loop}

\item{simulate.p.value}{Use simulated p-values in Fisher test or not}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{show.progress}{Show progress for each shift of the probability}

\item{show.results}{Show results}
}
\value{
Data frame with results from bMDD analysis
}
\description{
The basic idea of the calculation of bootstrap MDD (bMDD) using the CPCAT approach
is to shift the probability of binomial distribution until there is a certain proportion of
results significantly different from the control.
}
\examples{
CPFISH.contingency.table	# example data provided alongside the package

# Test CPFISH bootstrap MDD
CPFISH.bMDD(contingency.table = CPFISH.contingency.table,
		   control.name = NULL,
		   alpha = 0.05,
		   shift.step = -0.1,		# Caution: big step size for testing
		   bootstrap.runs = 10,		# Caution: low number of bootstrap runs for testing
		   power = 0.8,
		   max.iterations = 1000,
		   simulate.p.value = TRUE,
		   use.fixed.random.seed = 123,  #fixed seed for reproducible results
		   show.progress = TRUE,
		   show.results = TRUE)
}
