% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_companies.R
\name{get_companies}
\alias{get_companies}
\title{Builds a companies data frame from a text file.}
\usage{
get_companies(filepath = system.file("extdata/companies.txt", package = "qmj"))
}
\arguments{
\item{filepath}{Specifies the filepath of the text file containing the company names and 
tickers of interest. May be either absolute or relative to working directory.}
}
\value{
data.frame of companies info
}
\description{
\code{get_companies} reads in the contents of a text file
created from the pdf of company names and tickers given by
the Russell 3000 Index.
}
\details{
The user must copy and paste the contents of the Russell
3000 Index into a text file for this function to process the
data correctly. Simply select all of the component list and paste 
the contents into an empty document with
the .txt extension. The list may be found 
\href{https://www.lseg.com/en/ftse-russell}{here}.

If you wish to use your own text file of companies for get_companies to process,
create a text file containing each company on a separate line. Every word and ticker
must be capitalized, and the ticker must be the last word, separated by a space, on
each line.

\code{get_companies} by default uses a text file created from
the Russell 3000 Index in the package.
}
\section{Functions}{
\itemize{
\item \code{get_companies()}: function splits by space and grabs everything before 
the last word as the name and has the last word as the ticker.
Which chunk it returns is determined by the is_name variable.

}}
\examples{
get_companies()

}
