# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Set a calendar
#'
#' This function sets the default calendar to the given market or country convention.
#' Note that additional calendar objects can be created with the \code{getCalendar}
#' function.
#'
#' @title Set a calendar
#' @param calstr A character variable containing the market for which a calendar
#' is to be set
#' @return Nothing is returned but the global state is changed
#' @seealso \code{getCalendar}
#' @examples
#' setCalendar("UnitedStates/NYSE")  # sets global calendar
#' setCalendar("Canada/TSX")         # reset global calendar
setCalendar <- function(calstr) {
    invisible(.Call(`_qlcal_setCalendar`, calstr))
}

#' Advance a date to the next business day plus an optional shift
#'
#' This function takes a given date and advances it to the next business day
#' under the current (global) calendar setting. If an optional offset value is
#' given it is applied as well.
#'
#' @title Advance a date
#' @param rd A Date object describing the date to be advanced to the
#' next business day.
#' @param days An optional integer offset applied to the date
#' @param unit An optional character value denoting a time unit, default value
#' is \dQuote{Day}, and supported values are \dQuote{Days}, \dQuote{Weeks},
#' \dQuote{Months}, \dQuote{Years}, \dQuote{Hours}, \dQuote{Seconds},
#' \dQuote{Minutes}, \dQuote{Milliseconds}, \dQuote{Microseconds}.
#' @param bdc An optional integer defining a business day convention, default
#' is \dQuote{Following}, and supported values are
#' \dQuote{Following}, \dQuote{ModifiedFollowing}, \dQuote{Preceding},
#' \dQuote{ModifiedPreceding}, \dQuote{Unadjusted},
#' \dQuote{HalfMonthModifiedFollowing} and \dQuote{Nearest}.
#' @param eom An optional boolean toggle whether end-of-month is to be respected
#' @param xp An optional calendar object, if missing the default instance is used
#' @return The advanced date is returned
#' @examples
#' advanceDate(Sys.Date(), 2)  # today to the next biz day, plus 2 days
#' @seealso The \code{advanceUnits} functions offers the same functionality from R.
advanceDate <- function(rd, days = 0L, unit = "Days", bdc = "Following", eom = FALSE, xp = NULL) {
    .Call(`_qlcal_advanceDate`, rd, days, unit, bdc, eom, xp)
}

#' Test a vector of dates for business day
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a business day in the currently active (global) calendar.
#'
#' @title Test for business days
#' @param dates An optional Date vector with dates to be examined, if missing the
#' current day is used
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A logical vector indicating which dates are business days
#' @examples
#' isBusinessDay(Sys.Date()+0:6)
isBusinessDay <- function(dates = NULL, xp = NULL) {
    .Call(`_qlcal_isBusinessDay`, dates, xp)
}

#' Test a vector of dates for holiday
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a holiday in the currently active (global) calendar.
#'
#' @title Test for holidays
#' @param dates An optional Date vector with dates to be examined, if missing the
#' current day is used
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A logical vector indicating which dates are holidays
#' @examples
#' isHoliday(Sys.Date()+0:6)
isHoliday <- function(dates = NULL, xp = NULL) {
    .Call(`_qlcal_isHoliday`, dates, xp)
}

#' Test a vector of dates for weekends
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a weekend in the currently active (global) calendar.
#'
#' @title Test for weekends
#' @param dates An optional Date vector with dates to be examined, if missing the
#' current day is used
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A logical vector indicating which dates are weekends
#' @examples
#' isWeekend(Sys.Date()+0:6)
isWeekend <- function(dates = NULL, xp = NULL) {
    .Call(`_qlcal_isWeekend`, dates, xp)
}

#' Test a vector of dates for end-of-month
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is at the end of a month in the currently active (global) calendar.
#'
#' @title Test for end-of-month
#' @param dates An optional Date vector with dates to be examined, if missing the
#' current day is used
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A logical vector indicating which dates are end-of-month
#' @examples
#' isEndOfMonth(Sys.Date()+0:6)
isEndOfMonth <- function(dates = NULL, xp = NULL) {
    .Call(`_qlcal_isEndOfMonth`, dates, xp)
}

#' Compute a vector of dates with end-of-month
#'
#' This function takes a vector of dates and returns another vector of dates
#' of the same length returning at each position whether the corresponding
#' end-of-month date in the currently active (global) calendar.
#'
#' @title Compute end-of-month
#' @param dates A Date vector with dates
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A Date vector with dates which are end-of-month
#' @examples
#' getEndOfMonth(Sys.Date()+0:6)
getEndOfMonth <- function(dates, xp = NULL) {
    .Call(`_qlcal_getEndOfMonth`, dates, xp)
}

#' @rdname adjust
adjust_cpp <- function(dates, bdc = 0L, cal = NULL) {
    .Call(`_qlcal_adjust_cpp`, dates, bdc, cal)
}

#' @rdname advanceUnits
advanceUnits_cpp <- function(dates, n, unit, bdc, emr, cal = NULL) {
    .Call(`_qlcal_advanceUnits_cpp`, dates, n, unit, bdc, emr, cal)
}

#' Compute the number of business days between dates
#'
#' This function takes two vectors of start and end dates and returns another
#' vector of the number of business days between each corresponding date pair
#' according to the active calendar.
#'
#' @title Compute number of business dates between calendar dates
#' @param from A Date vector with interval start dates
#' @param to A Date vector with interval end dates
#' @param includeFirst A boolean indicating if the start date is included, default
#' is \sQuote{TRUE}
#' @param includeLast A boolean indicating if the end date is included, default
#' is \sQuote{FALSE}
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A numeric vector with the number of business dates between the
#' corresponding date pair
#' @examples
#' businessDaysBetween(Sys.Date() + 0:6, Sys.Date() + 3 + 0:6)
businessDaysBetween <- function(from, to, includeFirst = TRUE, includeLast = FALSE, xp = NULL) {
    .Call(`_qlcal_businessDaysBetween`, from, to, includeFirst, includeLast, xp)
}

#' Compute the number of holidays (or business days) between two dates
#'
#' This function takes a start and end date and returns a vector of holidays
#' (or business days) between them according to the active calendar.
#'
#' @title Compute holidays or business days
#' @param from A Date object with the start date
#' @param to A Date object with the end date
#' @param includeWeekends A boolean indicating if weekends should be included, default
#' is \sQuote{FALSE}
#' @param xp An optional calendar object, if missing the default instance is used
#' @return A Date vector with holidays or business days between the given dates
#' @examples
#' getHolidays(Sys.Date(), Sys.Date() + 30)
getHolidays <- function(from, to, includeWeekends = FALSE, xp = NULL) {
    .Call(`_qlcal_getHolidays`, from, to, includeWeekends, xp)
}

#' @rdname getHolidays
getBusinessDays <- function(from, to, xp = NULL) {
    .Call(`_qlcal_getBusinessDays`, from, to, xp)
}

#' Get new calendar
#'
#' This function returns an external pointer, classed as small S3 helper class,
#' to a new QuantLib Calendar object identified by the calendar string.
#'
#' @title Get new calendar objectb
#' @param calstr Character variable identifying desired calendar
#' @return A external pointer classed as S3 class 'qlcalendar'
#' @seealso \code{setCalendar}
#' @examples
#' xp <- getCalendar("UnitedStates/NYSE")
#' xp  # invokes the print method
#' xp2 <- getCalendar("Canada/TSX")
#' xp2 # invokes the print method
getCalendar <- function(calstr) {
    .Call(`_qlcal_getCalendar`, calstr)
}

#' Get calendar name or id
#'
#' This function returns the corresponding (full) name (as in the underlying
#' implementationclass) or identification string (used to select it) of the
#' current calendar.
#'
#' @title Get calendar name, or id
#' @param xp A calendar object created via \code{getCalendar}
#' @return A string with the calendar name
#' @examples
#' getName()
getName <- function(xp = NULL) {
    .Call(`_qlcal_getName`, xp)
}

#' @rdname getName
getId <- function(xp = NULL) {
    .Call(`_qlcal_getId`, xp)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_qlcal_RcppExport_registerCCallable`)
})
