% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actr.R
\name{actr}
\alias{actr}
\title{Actual correlations}
\usage{
actr(df)
}
\arguments{
\item{df}{data frame consisting of focal test and a set of criterion variables}
}
\description{
A very simple function, actr() computes the actual correlations between a focal test and a set of criterion variables
}
\details{
The df should contain only scores on the focal test and on the criterion variables. Any additional columns should be deleted.
Focal test scores should be in the first column. If you need to reorder columns, you can do so by column number - eg, df <- df[c(1,3,2)] -
or by column name - eg, df <- df[c("test", "crit1", "crit2")]

This function uses the "pairwise.complete.obs" option, which handles missing data by pairwise deletion.
}
\examples{
data(motdat)
actr(motdat)
}
