% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency.R
\name{currency_conversion}
\alias{currency_conversion}
\alias{qar_to_usd}
\alias{qar_to_eur}
\alias{usd_to_qar}
\alias{usd_to_eur}
\alias{eur_to_qar}
\alias{eur_to_usd}
\title{Convert between QAR, USD, and EUR}
\usage{
qar_to_usd(qar)

qar_to_eur(qar)

usd_to_qar(usd)

usd_to_eur(usd)

eur_to_qar(eur)

eur_to_usd(eur)
}
\arguments{
\item{qar}{numeric vector of values in Qatari Riyals}

\item{usd}{numeric vector of values in US Dollars}

\item{eur}{numeric vector of values in Euros}
}
\value{
Numeric vector of converted currency amounts
}
\description{
Functions to convert between Qatari Riyals (QAR), US Dollars (USD), and
Euros (EUR) using exchange rates from the time of data collection in
January 2025.
}
\details{
Exchange rates in January 2025:
\itemize{
\item 1 USD = 3.64 QAR
\item 1 EUR = 4.15 QAR
}
}
\examples{
qar_to_usd(100)
usd_to_eur(50)
eur_to_qar(25)

qatarcars$price_eur <- qar_to_eur(qatarcars$price)
qatarcars$price_usd <- qar_to_usd(qatarcars$price)
qatarcars[, c("origin", "make", "model", "price", "price_eur", "price_usd")]

# Labels are updated automatically
str(qatarcars$price)
str(qatarcars$price_eur)
str(qatarcars$price_usd)

if (require("dplyr")) {
  qatarcars |> 
    mutate(
      price_eur = qar_to_eur(price), 
      price_usd = qar_to_usd(price)
    ) |> 
    select(origin, make, model, starts_with("price"))
}
}
