\name{smoothIRSolid}
\alias{smoothIRSolid}
\title{
Smooth object generated by function \code{estimateIRsolid}
}
\description{
Adaptive smoothing of Rx and Sx maps over WM and GM areas.
}
\usage{
smoothIRSolid(IRmixedobj, kstar = 24, patchsize = 1, alpha = 0.025,
                   mscbw = 5, bysegment=TRUE, partial=TRUE, verbose=TRUE)
}
\arguments{
  \item{IRmixedobj}{
   object of class \code{IRmixed} generated by function \code{estimateIRsolid}
}
  \item{kstar}{
   number of steps for AWS algorithm
}
  \item{patchsize}{
   patchsize in paws
}
  \item{alpha}{
   significance level for decisions in aws algorithm (suggestion: between 1e-5 and 0.025)
}
  \item{mscbw}{
   bandwidth for 3D median smoother used to stabilize the covariance estimates.
}
   \item{bysegment}{
   \code{TRUE}: restrict smoothing to segments from segmentation, \code{FALSE}: restrict smoothing to solid mask.
}
   \item{partial}{
   \code{TRUE}: ignore information concerning parameter \code{fx} when smoothing.  
}
 \item{verbose}{
   logical: Monitor process.
}
}
\details{
  This uses a vectorized version of the AWS algorithm that emloys inverse covariance estimates of the estimated parameters. Local smoothing is done for Rx and Sx maps in ergs which can be assumed to be locally smooth within tissue. No smoothing for fx maps since they may vary.
}
\value{
an object of class \code{"IRmixed"}, but with components Sx and Rx replaced. The object carries an additional component \code{bi} containing an array of sum of weights characterizing the amount of smoothing.
}
\references{
J. Polzehl and K. Tabelow (2023), Magnetic Resonance Brain Imaging:
Modeling and Data Analysis Using R, 2nd Edition, Chapter 7, Springer, Use R! Series.
    <doi:10.1007/978-3-031-38949-8_7>.

J. Polzehl and K. Tabelow (2023), Magnetic Resonance Brain Imaging - 
Modeling and Data Analysis Using R: Code and Data.
    <doi:10.20347/WIAS.DATA.6>.

}
\author{
Karsten Tabelow \email{tabelow@wias-berlin.de}\cr
J\"org Polzehl \email{polzehl@wias-berlin.de}
}

\seealso{
 \code{\link{estimateIRfluid}}, \code{\link{estimateIRsolid}}, \code{\link{estimateIRsolidfixed}},\code{\link{estimateIR}}
}
\examples{
\donttest{
## runs about 10 seconds
dataDir0 <- system.file("extdataIR", package = "qMRI")
dataDir <- tempdir()
library(oro.nifti)
library(qMRI)
segm <- readNIfTI(file.path(dataDir0,"Brainweb_segm"))
Sf <- 900
Rf <- 0.000285
Sgm <- 400
Rgm <- 0.00075
fgm <- .15
Swm <- 370
Rwm <- 0.0011
fwm <- .05
InvTimes0 <- c(100, 200, 400, 600, 800, 1200, 1600, 2000, 2500, 3000, 
              3500, 4000, 4500, 5000, 6000, 15000)
nTimes <- length(InvTimes0)
sigma <- 40
## generate IR signal
IRdata <- generateIRData(segm, c(Sf,Rf), c(fgm,Rgm,Sgm), c(fwm,Rwm,Swm), InvTimes0, sigma)
for(i in 1:9) writeNIfTI(as.nifti(IRdata[i,,,]), 
                         file.path(dataDir,paste0("IR0",i)))
for(i in 10:nTimes) writeNIfTI(as.nifti(IRdata[i,,,]), 
                         file.path(dataDir,paste0("IR",i)))
## generate IRdata object
t1Files <- list.files(dataDir,"*.nii.gz",full.names=TRUE)
segmFile <- file.path(dataDir0,"Brainweb_segm")
IRdata <- readIRData(t1Files, InvTimes0, segmFile, sigma=sigma,
                     L=1, segmCodes=c("CSF","GM","WM"))
## estimate fluid
setCores(2) # parallel mode using 2 threads
IRfluid <- estimateIRfluid(IRdata, method="NLR", verbose=FALSE)
cat("Estimated parameters Sf:", IRfluid$Sf, 
                        " Rf:", IRfluid$Rf, "\n")
## estimate solid
IRmix <- estimateIRsolid(IRfluid, verbose=FALSE)
## smoothing 
sIRmix <- smoothIRSolid(IRmix, alpha=1e-4, partial=FALSE, verbose=FALSE)
}
}
 \keyword{ utilities }
 \keyword{ smooth }
 \concept{ IRMRI }
