% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr.rasch.R
\name{pwr.rasch}
\alias{pwr.rasch}
\title{Simulation to Estimate Statistical Power of a Rasch Model Test}
\usage{
pwr.rasch(
  b,
  ipar = list(),
  design = NULL,
  ppar = list("rnorm(b, mean = 0, sd = 1.5)", "rnorm(b, mean = 0, sd = 1.5)"),
  runs = 1000,
  H0 = TRUE,
  sig.level = 0.05,
  method = c("loop", "vectorized"),
  output = TRUE
)
}
\arguments{
\item{b}{Either a vector or an integer indicating the number of observations in each group.}

\item{ipar}{Item parameters in both groups specified in a list.}

\item{design}{Test booklet design}

\item{ppar}{Person parameters specified by a distribution for each group.}

\item{runs}{Number of simulation runs.}

\item{H0}{If \code{TRUE}, null hypothesis condition is simulated.}

\item{sig.level}{Nominal significance level.}

\item{method}{Simulation method: for-loop or vectorized.}

\item{output}{If \code{TRUE}, output is shown.}
}
\value{
Returns a list with following entries:

\tabular{ll}{ 
  \code{b}         \tab number of observations in each group \cr
  \code{ipar}      \tab item parameters in both subgroups \cr
  \code{design}    \tab test booklet design \cr
  \code{c}         \tab number of items \cr
  \code{ppar}      \tab distribution of person parameters \cr
  \code{runs}      \tab number of simulation runs \cr
  \code{sig.level} \tab nominal significance level \cr
  \code{H0.AC.p}   \tab \emph{p}-values of the interaction A x C in the null hypothesis condition (if \code{H0 = TRUE}) \cr
  \code{H1.AC.p}   \tab \emph{p}-values of the interaction A x C in the alternative hypothesis condition \cr
  \code{power}     \tab estimated statistical power \cr
  \code{type1}     \tab estimated significance level \cr
}
}
\description{
This function conducts a simulation to estimate statistical power 
of a Rasch model test for user-specified item and person parameters.
}
\details{
The F-test in a three-way analysis of variance design   \eqn{(A \succ \mathbf{B}) x C}{}(A > \strong{B}) x C
with mixed classification (fixed factor A = subgroup, random factor B = testee, 
and fixed factor C = items) is used to simulate statistical power of a
Rasch model test. This approach using a F-distributed statistic, where 
the sample size directly affects the degree of freedom enables determination
of the sample size according to a given type I  and type II risk, and according 
to a certain effect of model misfit which is of practical relevance. 
Note, that this approach works as long as there exists no main effect of
A (subgroup). Otherwise an artificially high type I risk of the A x C interaction
F-test results - that is, the approach works as long as no statistically significant
main effect of A occurs.
}
\examples{
\dontrun{

# item parameters
ipar2 <- ipar1 <- seq(-3, 3, length.out = 20)
# model differential item function (DIF)
ipar2[10] <- ipar1[11]
ipar2[11] <- ipar1[10]
# simulation for b = 200 
pwr.rasch(200, ipar = list(ipar1, ipar2))

# simulation for b = 100, 200, 300, 400, 500 
pwr.rasch(seq(100, 500, by = 100), ipar = list(ipar1, ipar2))

# simulation for b = 100, 200, 300, 400, 500 
# uniform distribution [-3, 3] of person parameters
pwr.rasch(200, ipar = list(ipar1, ipar2), ppar = list("runif(b, -3, 3)", "runif(b, -3, 3)"))
}
}
\references{
Kubinger, K. D., Rasch, D., & Yanagida, T. (2009). On designing data-sampling for Rasch model 
calibrating an achievement test. \emph{Psychology Science Quarterly, 51}, 370-384.

Kubinger, K. D., Rasch, D., & Yanagida, T. (2011). A new approach for testing the Rasch model.
\emph{Educational Research and Evaluation, 17}, 321-333.
}
\seealso{
\code{\link{aov.rasch}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Jan Steinfeld \email{jan.steinfeld@univie.ac.at}
}
