% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hwd}
\alias{hwd}
\title{Deviation from Hardy-Weinberg equilibrium}
\usage{
hwd(ped, reference = NULL)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}
}
\value{
A numeric value indicating the deviation from Hardy-Weinberg equilibrium.
}
\description{
Computes the deviation from Hardy-Weinberg equilibrium following Caballero and Toro (2000).
}
\references{
\itemize{
  \item{Caballero A, Toro M. 2000. Interrelations between effective population size and other pedigree tools for the management of conserved populations. Genet. Res. 75: 331-343.}
}
}
\seealso{
\code{\link{pop_Ne}}
}
