% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_pum_static.R
\name{sample_pum_static}
\alias{sample_pum_static}
\title{Generate posterior samples from the static probit unfolding model}
\usage{
sample_pum_static(
  vote_info,
  hyperparams,
  control,
  pos_leg = 0,
  verbose = FALSE,
  pre_run = NULL,
  appended = FALSE
)
}
\arguments{
\item{vote_info}{A logical vote matrix (or a rollcall object) in which rows represent members and columns represent issues.}

\item{hyperparams}{A list of hyperparameter values:
- `beta_mean`: Prior mean for beta.
- `beta_var`: Variance of beta.
- `alpha_mean`: A vector of two components representing the prior means of `alpha1` and `alpha2`.
- `alpha_scale`: Scale parameter for `alpha1` and `alpha2`.
- `delta_mean`: A vector of two components representing the prior means of `delta1` and `delta2`.
- `delta_scale`: Scale parameter for `delta1` and `delta2`.}

\item{control}{A list of MCMC configurations:
- `num_iter`: Total number of iterations. It is recommended to set this to at least 30,000 to ensure reliable results.
- `burn_in`: The number of initial iterations to discard as part of the burn-in period before retaining samples.
- `keep_iter`: Interval at which iterations are kept for posterior samples.
- `flip_rate`: Probability of directly flipping signs in the M-H step, rather than resampling from the priors.}

\item{pos_leg}{Name of the legislator whose position is kept positive.}

\item{verbose}{Logical. If `TRUE`, prints progress and additional information during the sampling process.}

\item{pre_run}{A list containing the output from a previous run of the function. If provided, the last iteration of the previous run will be used as the initial point of the new run. Defaults to `NULL`.}

\item{appended}{Logical. If `TRUE`, the new samples will be appended to the samples from the previous run. Defaults to `FALSE`.}
}
\value{
A list primarily containing:
  - `beta`: A matrix of posterior samples for `beta`.
  - `alpha1`: A matrix of posterior samples for `alpha1`.
  - `alpha2`: A matrix of posterior samples for `alpha2`.
  - `delta1`: A matrix of posterior samples for `delta1`.
  - `delta2`: A matrix of posterior samples for `delta2`.
  - `vote_info`: The input vote object.
}
\description{
This function generates posterior samples of all parameters based on the static probit unfolding model.
}
\examples{
\donttest{
# Long-running example
data(h116)
h116.c = preprocess_rollcall(h116)
hyperparams <- list(beta_mean = 0, beta_var = 1, alpha_mean = c(0, 0),
                    alpha_scale = 5, delta_mean = c(-2, 10), delta_scale = sqrt(10))
control <- list(num_iter = 2, burn_in = 0, keep_iter = 1, flip_rate = 0.1)
h116.c.pum <- sample_pum_static(h116.c, hyperparams,
                                  control, pos_leg = grep("SCALISE", rownames(h116.c$votes)),
                                  verbose = FALSE, pre_run = NULL, appended = FALSE)
}
}
