% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{ExtractParameters}
\alias{ExtractParameters}
\alias{extract_theta0}
\alias{extract_theta}
\alias{extract_tau}
\alias{extract_eta}
\alias{extract_isq}
\title{Extract Parameters from an \code{mafit} Object}
\usage{
extract_theta0(object, fun = mean)

extract_theta(object, fun = mean, i)

extract_tau(object, fun = mean)

extract_eta(object, fun = mean, i)

extract_isq(object, fun = mean)
}
\arguments{
\item{object}{an object of class \code{\link[=mafit-class]{mafit}}.}

\item{fun}{the function to be applied to the fitted parameters.}

\item{i}{an optional index specifying which parameter to apply \code{fun} to. Only
for \code{extract_eta} and \code{extract_theta}.}
}
\value{
The result of \code{FUN} being applied to all estimated parameters of
\code{object}.
}
\description{
Extract samples from a model of class \code{\link[=mafit-class]{mafit}} and apply a
function \code{fun} to them.
}
\details{
Support parameters for extraction are: The meta-analytic mean \code{theta0}, the
individual means \code{theta}, the heterogeneity parameter \code{tau}, the selection
bias parameter \code{eta}, and the I squared \code{isq}. See Higgins and Thompson
(2002) for details about I squared.

All \code{extract_} functions are wrappers
around \code{\link[rstan:stanfit-method-extract]{rstan::extract}}.
}
\examples{
\donttest{
set.seed(313)
model <- publipha::psma(yi = yi, vi = vi, data = dat.baskerville2012)
extract_theta0(model, mean) # [1] extract_theta0(model, mean)
extract_theta0(model, sd) # [1] 0.1095921
extract_tau(model, mean) # [1] 0.1315312
extract_theta(model, hist, i = 5)
}
}
\references{
Higgins, J. P., & Thompson, S. G. (2002). Quantifying
heterogeneity in a meta-analysis. Statistics in medicine, 21(11), 1539-1558.
}
