% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte_aggte.R
\name{pte_aggte}
\alias{pte_aggte}
\title{Aggregates (g,t)-Specific Results}
\usage{
pte_aggte(
  attgt,
  type = "overall",
  balance_e = NULL,
  min_e = -Inf,
  max_e = Inf,
  ...
)
}
\arguments{
\item{attgt}{A group_time_att object to be aggregated}

\item{type}{The type of aggregation to be done.  Default is "overall".}

\item{balance_e}{Drops groups that do not have at least \code{balance_e} periods
of post-treatment data.  This keeps the composition of groups constant
across different event times in an event study.
Default is NULL, in which case this is ignored.}

\item{min_e}{The minimum event time computed in the event study results.
This is useful when there are a huge number of pre-treatment periods.}

\item{max_e}{The maximum event time computed in the event study results.
This is useful when there are a huge number of post-treatment periods.}

\item{...}{extra arguments}
}
\value{
an \code{aggte_obj}
}
\description{
This is a slight edit of the aggte function from the \code{did} package.
Currently, it only provides aggregations for "overall" treatment effects
and event studies.  It also will provide the weights directly which is
currently used for constructing aggregations based on distributions.
The other difference is that, \code{pte_aggte} provides inference results
where the only randomness is coming from the outcomes (not from the group
assignment nor from the covariates).
}
