% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stuff.R
\name{get_stuff}
\alias{get_stuff}
\alias{get_escalc}
\alias{get_metafor}
\alias{get_metatab}
\alias{get_ad}
\alias{get_followup}
\alias{get_heterogeneity}
\alias{get_leave1out}
\alias{get_cumulative}
\alias{get_bootstrap}
\alias{get_metareg}
\alias{get_matrix}
\alias{get_plots}
\title{Extract results from a psychmeta meta-analysis object}
\usage{
get_stuff(
  ma_obj,
  what = c("metatab", "escalc", "metafor", "ad", "followup", "heterogeneity",
    "leave1out", "cumulative", "bootstrap", "metareg", "matrix", "plots"),
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ma_method = c("bb", "ic", "ad"),
  correction_type = c("ts", "vgx", "vgy"),
  moderators = FALSE,
  as_ad_obj = TRUE,
  inputs_only = FALSE,
  ad_type = c("tsa", "int"),
  follow_up = c("heterogeneity", "leave1out", "cumulative", "bootstrap", "metareg"),
  plot_types = c("funnel", "forest", "leave1out", "cumulative"),
  ...
)

get_escalc(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  moderators = TRUE,
  ...
)

get_metafor(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  moderators = TRUE,
  ...
)

get_metatab(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ma_method = c("bb", "ic", "ad"),
  correction_type = c("ts", "vgx", "vgy"),
  ...
)

get_ad(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ma_method = c("ad", "ic"),
  ad_type = c("tsa", "int"),
  as_ad_obj = FALSE,
  inputs_only = FALSE,
  ...
)

get_followup(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  follow_up = c("heterogeneity", "leave1out", "cumulative", "bootstrap", "metareg"),
  ...
)

get_heterogeneity(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_leave1out(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_cumulative(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_bootstrap(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_metareg(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_matrix(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  ...
)

get_plots(
  ma_obj,
  analyses = "all",
  match = c("all", "any"),
  case_sensitive = TRUE,
  plot_types = c("funnel", "forest", "leave1out", "cumulative"),
  ...
)
}
\arguments{
\item{ma_obj}{A psychmeta meta-analysis object.}

\item{what}{For the \code{get_stuff()} function only: Character scalar telling \code{get_stuff()} what to get.
All suffixes from functions in the "get_" family can be passed as arguments to \code{what}:
"metatab", "escalc", "metafor", "ad", "followup", "heterogeneity", "leave1out", "cumulative", "bootstrap", "metareg", "matrix", "plots"}

\item{analyses}{Which analyses to extract? Can be either \code{"all"} to extract references for all meta-analyses in the object (default) or a list containing one or more of the following arguments:
\itemize{
\item{\code{construct}: A list or vector of construct names to search for.}
\item{\code{construct_pair}: A list of vectors of construct pairs to search for. \cr
(e.g., \code{list(c("X", "Y"), c("X", "Z"))}).}
\item{\code{pair_id}: A list or vector of numeric construct pair IDs (unique construct-pair indices).}
\item{\code{analysis_id}: A list or vector of numeric analysis IDs (unique analysis indexes).}
\item{\code{k_min}: A numeric value specifying the minimum \code{k} for extracted meta-analyses.}
\item{\code{N_min}: A numeric value specifying the minimum \code{N} for extracted meta-analyses.}
}}

\item{match}{Should extracted meta-analyses match all (default) or any of the criteria given in \code{analyses}?}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{ma_method}{Meta-analytic methods to be included. Valid options are: "bb", "ic", and "ad"}

\item{correction_type}{Types of meta-analytic corrections to be included. Valid options are: "ts", "vgx", and "vgy"}

\item{moderators}{Logical scalar that determines whether moderator variables should be included in escalc objects (\code{TRUE}; default) or not (\code{FALSE}).}

\item{as_ad_obj}{Logical scalar that determines whether artifact information should be returned as artifact-distribution objects (\code{TRUE}) or a summary table of artifact-distribution descriptive statistics (\code{FALSE}; default).}

\item{inputs_only}{Used only if \code{as_ad_obj = TRUE}: Logical scalar that determines whether artifact information should be returned as summaries of the raw input values (\code{TRUE}) or artifact values that may have been cross-corrected for range restriction and measurement error (\code{FALSE}; default).}

\item{ad_type}{Used only if \code{ma_method} = "ic": Character value(s) indicating whether Taylor-series approximation artifact distributions ("tsa") and/or interactive artifact distributions ("int") should be retrieved.}

\item{follow_up}{Vector of follow-up analysis names (options are: "heterogeneity", "leave1out", "cumulative", "bootstrap", "metareg").}

\item{plot_types}{Vector of plot types (options are: "funnel", "forest", "leave1out", "cumulative"; multiple allowed).}

\item{...}{Additional arguments.}
}
\value{
Selected set of results.
}
\description{
Functions to extract specific results from a meta-analysis tibble.
This family of functions harvests information from meta-analysis objects and returns it as lists or tibbles that are easily navigable.

Available functions include:
\itemize{
\item{\code{get_stuff}: Wrapper function for all other "get_" functions.}
\item{\code{get_metatab}: Retrieve list of meta-analytic tables.}
\item{\code{get_ad}: Retrieve list of artifact-distribution objects or a summary table of artifact descriptive statistics.}
\item{\code{get_plots}: Retrieve list of meta-analytic plots.}
\item{\code{get_escalc}: Retrieve list of escalc objects (i.e., effect-size data) for use with \pkg{metafor}.}
\item{\code{get_metafor}: Alias for \code{get_escalc}.}
\item{\code{get_followup}: Retrieve list of follow-up analyses.}
\item{\code{get_leave1out}: Retrieve list of leave-one-out meta-analyses (special case of \code{get_followup}).}
\item{\code{get_cumulative}: Retrieve list of cumulative meta-analyses (special case of \code{get_followup}).}
\item{\code{get_bootstrap}: Retrieve list of bootstrap meta-analyses (special case of \code{get_followup}).}
\item{\code{get_metareg}: Retrieve list of meta-regression analyses (special case of \code{get_followup}).}
\item{\code{get_heterogeneity}: Retrieve list of heterogeneity analyses (special case of \code{get_followup}).}
\item{\code{get_matrix}: Retrieve a tibble of matrices summarizing the relationships among constructs (only applicable to meta-analyses with multiple constructs).}
}
}
\examples{
\dontrun{
## Run meta-analysis:
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name,
               sample_id = sample_id, citekey = NULL,
               moderators = moderator, data = data_r_meas_multi,
               impute_artifacts = FALSE, clean_artifacts = FALSE)
ma_obj <- ma_r_ad(ma_obj, correct_rr_x = FALSE, correct_rr_y = FALSE)

## Run additional analyses:
ma_obj <- heterogeneity(ma_obj)
ma_obj <- sensitivity(ma_obj, boot_iter = 10, boot_ci_type = "norm")
ma_obj <- metareg(ma_obj)
ma_obj <- plot_funnel(ma_obj)
ma_obj <- plot_forest(ma_obj)

## View summary:
summary(ma_obj)

## Extract selected analyses:
get_metatab(ma_obj)
get_matrix(ma_obj)
get_escalc(ma_obj)
get_bootstrap(ma_obj)
get_cumulative(ma_obj)
get_leave1out(ma_obj)
get_heterogeneity(ma_obj)
get_metareg(ma_obj)
get_plots(ma_obj)
get_ad(ma_obj, ma_method = "ic", as_ad_obj = TRUE)
get_ad(ma_obj, ma_method = "ic", as_ad_obj = FALSE)

## Same extractions as above, but using get_stuff() and the "what" argument:
get_stuff(ma_obj, what = "metatab")
get_stuff(ma_obj, what = "matrix")
get_stuff(ma_obj, what = "escalc")
get_stuff(ma_obj, what = "bootstrap")
get_stuff(ma_obj, what = "cumulative")
get_stuff(ma_obj, what = "leave1out")
get_stuff(ma_obj, what = "heterogeneity")
get_stuff(ma_obj, what = "metareg")
get_stuff(ma_obj, what = "plots")
get_stuff(ma_obj, what = "ad", ma_method = "ic", as_ad_obj = TRUE)
get_stuff(ma_obj, what = "ad", ma_method = "ic", as_ad_obj = FALSE)
}
}
