% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{effectsizeValueString}
\alias{effectsizeValueString}
\title{effectsizeValueString}
\usage{
effectsizeValueString(aovObj, effect, effectSize = "pes")
}
\arguments{
\item{aovObj}{Output from aov or ezANOVA (NB. ezANOVA must be called with detailed = TRUE)}

\item{effect}{The effect within the ANOVA table to return}

\item{effectSize}{pes (partial eta squared) vs. ges (generalised eta squared)}
}
\value{
character
}
\description{
Returns required Latex formatted string for effect
size (partial eta squared) = XXX for R/knitr integration.
Returns values to 2 sig decimal places.
}
\examples{
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) and 2(Side: left vs. right)
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat, RT = list("Comp:Side comp:left"    = c(500, 150, 100),
                                "Comp:Side comp:right"   = c(500, 150, 100),
                                "Comp:Side incomp:left"  = c(520, 150, 100),
                                "Comp:Side incomp:right" = c(520, 150, 100)))

aovRT <- aov(RT ~ Comp*Side + Error(VP/(Comp*Side)), dat)
aovRT <- aovTable(aovRT)

pesString <- effectsizeValueString(aovRT, "Comp")  # partial eta squared
pesString <- effectsizeValueString(aovRT, "Comp:Side")

# or using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

pesString <- effectsizeValueString(aovRT, "Comp")  # partial eta squared
pesString <- effectsizeValueString(aovRT, "Comp:Side")

}
