% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readjustWindow.R
\name{readjustWindows}
\alias{readjustWindows}
\title{Readjust windows so that boundaries in regions of few peaks.}
\usage{
readjustWindows(wind, ms1data, digits = 1, maxbin = 15, plot = FALSE)
}
\arguments{
\item{wind}{a data frame with columns from and to}

\item{ms1data}{masses}

\item{digits}{mass accuracy}

\item{maxbin}{maximum number of bins}

\item{plot}{diagnostic plots (default FALSE)}
}
\value{
data.frame of same format as \code{wind} but with improved start and end masses.
}
\description{
Readjust windows so that boundaries in regions of few peaks.
}
\examples{
data(masses)
cdsw <- Cdsw(masses)
breaks <- cdsw$sampling_breaks(maxwindow=100,plot=TRUE)
table <- cdsw$asTable()
dim(table)
head(table)

tmp <- readjustWindows(table, masses,maxbin=10)
data.frame(tmp)

}
