% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pj_estimate.R
\name{pj_estimate}
\alias{pj_estimate}
\title{Internal Estimation Function}
\usage{
pj_estimate(
  .data,
  .structure,
  .estimand,
  .att_choose,
  .lev_choose,
  .att_notchoose,
  .lev_notchoose,
  .att_choose_b,
  .lev_choose_b,
  .att_notchoose_b,
  .lev_notchoose_b,
  .se_method,
  .irr,
  .remove_ties,
  .ignore_position,
  .n_sims,
  .n_boot,
  .weights_1,
  .clusters_1,
  .se_type_1,
  .weights_2,
  .clusters_2,
  .se_type_2,
  .auto_cluster = TRUE,
  .seed = NULL
)
}
\arguments{
\item{.data}{A \code{\link{projoint_data}} object created by \code{\link{reshape_projoint}} or \code{\link{make_projoint_data}}.}

\item{.structure}{Either \code{"profile_level"} or \code{"choice_level"}.}

\item{.estimand}{Either \code{"mm"} (marginal mean) or \code{"amce"} (average marginal component effect).}

\item{.att_choose}{Attribute for the chosen profile/feature.}

\item{.lev_choose}{Level(s) for the chosen profile/feature. Length 1 for \code{profile_level}; may be 1+ for \code{choice_level}.}

\item{.att_notchoose}{Attribute for the not-chosen profile/feature (required for \code{choice_level}).}

\item{.lev_notchoose}{Level(s) for the not-chosen profile/feature (required for \code{choice_level}).}

\item{.att_choose_b}{(AMCE only) Baseline attribute for comparison.}

\item{.lev_choose_b}{(AMCE only) Baseline level(s) for comparison.}

\item{.att_notchoose_b}{(AMCE only, choice-level only) Baseline attribute for the not-chosen profile.}

\item{.lev_notchoose_b}{(AMCE only, choice-level only) Baseline level(s) for the not-chosen profile.}

\item{.se_method}{One of \code{"analytical"}, \code{"simulation"}, or \code{"bootstrap"}.}

\item{.irr}{\code{NULL} (default) to estimate IRR from repeated tasks; otherwise a numeric IRR value.}

\item{.remove_ties}{Logical; should ties be removed before estimation? Defaults to \code{TRUE}.}

\item{.ignore_position}{Logical; only for \code{choice_level}. If \code{TRUE} (default), ignore profile position (left/right).}

\item{.n_sims}{Integer; required if \code{.se_method == "simulation"}.}

\item{.n_boot}{Integer; required if \code{.se_method == "bootstrap"}.}

\item{.weights_1}{(Optional) Bare (unquoted) column with weights for IRR estimation; passed to \code{\link[estimatr]{lm_robust}}.}

\item{.clusters_1}{(Optional) Bare (unquoted) column with clusters for IRR estimation; passed to \code{\link[estimatr]{lm_robust}}.}

\item{.se_type_1}{SE type for IRR estimation; passed to \code{\link[estimatr]{lm_robust}}. If \code{NULL}, \emph{estimatr} defaults are used (HC2 when unclustered; CR2 when clustered).}

\item{.weights_2}{(Optional) Bare (unquoted) column with weights for MM/AMCE estimation; passed to \code{\link[estimatr]{lm_robust}}.}

\item{.clusters_2}{(Optional) Bare (unquoted) column with clusters for MM/AMCE estimation; passed to \code{\link[estimatr]{lm_robust}}.}

\item{.se_type_2}{SE type for MM/AMCE estimation; passed to \code{\link[estimatr]{lm_robust}}. If \code{NULL}, \emph{estimatr} defaults are used (HC2 when unclustered; CR2 when clustered).}

\item{.auto_cluster}{Logical; if \code{TRUE} (default), auto-cluster on \code{id} when present and no \code{.clusters_*} are supplied; auto-clustering only occurs when the corresponding \code{.se_type_*} is \code{NULL}. See \code{\link{projoint}}.}

\item{.seed}{Optional integer. If supplied, sets a temporary RNG seed for reproducible simulation/bootstrap inside this call 
and restores the previous RNG state on exit.}
}
\value{
A data frame with rows for the requested estimand(s) and columns:
  \itemize{
    \item \code{estimand}: one of \code{"mm_uncorrected"}, \code{"mm_corrected"},
          \code{"amce_uncorrected"}, \code{"amce_corrected"}.
    \item \code{estimate}, \code{se}, \code{conf.low}, \code{conf.high}, \code{tau}.
  }
}
\description{
Core workhorse for computing marginal means (MMs) or AMCEs from a conjoint design,
with optional intra-respondent reliability (IRR) correction.
}
\details{
IRR is clipped to \code{[0.5, 1)} (with a tiny epsilon) to avoid boundary issues.
For choice-level MMs, ties must be removed (\code{.remove_ties = TRUE}).
When \code{.seed} is supplied, the previous RNG state is restored on exit.
}
\seealso{
\code{\link[estimatr]{lm_robust}}, \code{\link{projoint}},
  \code{\link{projoint_level}}, \code{\link{projoint_diff}}
}
\keyword{internal}
