% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pprof.R
\name{pprof}
\alias{pprof}
\title{Profile R code and visualize with pprof.}
\usage{
pprof(
  expr,
  seconds_timeout = Inf,
  host = "localhost",
  port = proffer::random_port(),
  browse = interactive(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{expr}{R code to run and profile.}

\item{seconds_timeout}{Maximum number of seconds of elapsed time
to profile \code{expr}. When the timeout is reached, \code{proffer} stops running
\code{expr} and returns the profiling samples taken during the
\code{seconds_timeout} time window.}

\item{host}{Host name. Set to \code{"localhost"} to view locally
or \code{"0.0.0.0"} to view from another machine. If you view
from another machine, the printed out URL will not be valid.
For example, if \code{pprof()} or \code{serve_pprof()} prints
"http://0.0.0.0:8080", then you need to replace 0.0.0.0
with your computer's name or IP address, e.g.
"http://my_computer.com:8080".}

\item{port}{Port number for hosting the local pprof server.
Chosen randomly by default.}

\item{browse}{Logical, whether to open a browser to view
the pprof server.}

\item{verbose}{Logical, whether to print console messages
such as the URL of the local \code{pprof} server.}

\item{...}{Additional arguments passed on to \code{\link[=Rprof]{Rprof()}}
via \code{\link[=record_pprof]{record_pprof()}}.}
}
\value{
A \code{processx::process$new()} handle. Use this handle
to take down the server with \verb{$kill()}.
}
\description{
Run R code and display profiling results
in a local interactive pprof server.
Results are collected with \code{\link[=record_pprof]{record_pprof()}}.
}
\examples{
if (identical(Sys.getenv("PROFFER_EXAMPLES"), "true")) {
# Start a pprof virtual server in the background.
px <- pprof(replicate(1e2, sample.int(1e4)))
# Terminate the server.
px$kill()
}
}
