% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.prodlim.R
\name{as_tibble.prodlim}
\alias{as_tibble.prodlim}
\title{Turn prodlim objects into a \code{\link[tibble]{tibble}}}
\usage{
as_tibble.prodlim(x, ...)
}
\arguments{
\item{x}{object obtained with function \code{\link{prodlim}}}

\item{...}{passed to \code{\link{summary.prodlim}}}
}
\value{
A data.table with the results of the prodlim object
}
\description{
Collect results of a fitted prodlim object in a tibble
}
\details{
By default object contains results for all fitted time points and all strata.
Use arguments times and newdata of \code{\link{summary.prodlim}} to subset.
}
\examples{
library(tibble)
set.seed(8)
d <- SimCompRisk(17)
fit <- prodlim(Hist(time,event)~X1,data=d)
tibble::as_tibble(fit)

}
\seealso{
\code{\link{prodlim}}, \code{\link[tibble]{tibble}}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
