% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_name_attribute}
\alias{add_name_attribute}
\title{Helper method for custom distributions}
\usage{
add_name_attribute(func, name)
}
\arguments{
\item{func}{Function, for example the \code{p}- or \code{d}- form of a distribution
function.}

\item{name}{Character string, starting with "p" or "d" indicating the
underlying distribution.}
}
\value{
Function, with a "name" attribute added
}
\description{
\code{\link[=pprimarycensored]{pprimarycensored()}} and related functions can identify which distributions
are provided via the \code{pdist} and \code{dprimary} arguments when those are base R
functions (e.g. \code{punif}, \code{dexp}) via the \code{name} attribute.
}
\details{
If you need to use a non-base R implementation, but know the distribution
name, you can use this helper function to set it in a way that will be
detected by \code{\link[=pprimarycensored]{pprimarycensored()}} and related functions.

This is useful as it enables the automatic use of analytical solutions for
distributions where they exist. You can check which analytical solutions are
available using \code{methods(pcens_cdf)} and check distribution names using
\code{\link[=pcd_dist_name]{pcd_dist_name()}}.
}
\examples{
dist <- add_name_attribute(pnorm, "hello")
attr(dist, "name")
}
\seealso{
Utility functions for working with distributions
\code{\link{pcd_dist_name}()},
\code{\link{pcd_distributions}},
\code{\link{pcd_primary_distributions}}
}
\concept{utils}
