% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast-models.R
\name{prevedere_forecast}
\alias{prevedere_forecast}
\title{Forecast}
\usage{
prevedere_forecast(key, model_id, as_of_date = NULL, raw = FALSE)
}
\arguments{
\item{key}{A Prevedere API key.}

\item{model_id}{UUID for the forecast model.}

\item{as_of_date}{Get the model only using data up to the specified date (YYYY-MM-DD). Used for backtesting.}

\item{raw}{Logical value indicating if data should be returned in its raw form
(typically nested lists) or formatted as appropriate, usually a dataframe.}
}
\value{
A dataframe of forecasted values and metadata.
}
\description{
Returns historical fit and forecasted values of a forecast model.
}
\examples{
\dontrun{
k <- "1235467abcdefg"

prevedere_forecast(key = k, model_id = "1b1878399833c7f38b094e54dd43d374")
}
}
\seealso{
Other forecast model functions: \code{\link{prevedere_raw_model}}
}
\concept{forecast model functions}
