% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{is_integer_value}
\alias{is_integer_value}
\title{Is Integer Value}
\usage{
is_integer_value(input_value, allow_na = FALSE)
}
\arguments{
\item{input_value}{The input value}

\item{allow_na}{If true, NA values
are ignored and output is considered TRUE.
Default: FALSE}
}
\value{
A boolean indicating TRUE
when the input value is an integer and
FALSE otherwise.
}
\description{
Function to check if the input
value is an integer.
}
\examples{

# An integer
is_integer_value(1)

# Not an integer
is_integer_value(1.1)

# Not numeric
is_integer_value("1")

# NA cases
is_integer_value(NA, allow_na = FALSE)
is_integer_value(NA, allow_na = TRUE)

}
