\name{preseqR.simu.hist}
\alias{preseqR.simu.hist}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
    Simulation
}
\description{
    Generating a histogram based on a Poisson mixture model. 
}
\usage{
  preseqR.simu.hist(L=1e8, N, FUN)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{L}{
    A positive integer, the number of species in a population.
}
  \item{N}{
    A positive interger, the simulated sample size.
  }
  \item{FUN}{
    An RNG generating non negative real number.
  } 
}
\details{
  \code{preseqR.simu.hist} uses a mixture of Poisson distributions to generate
  a sample, which size is defined by the variable \eqn{N}. 
  The statistical assumption is that for each species the number of individuals
  captured in a sample follows a Poisson process. 
  The Poisson rates among species are generated by a given
  function \code{FUN} per unit of sampling effort.

  \code{FUN} must take an argument indicating the number of random
  numbers generated and return a vector of generated numbers. 
}
\value{
    A two-column matrix.  
    The first column is the frequency \eqn{j = 1,2,\dots}; and the second column
    is \eqn{N_j}, the number of species with each species represented exactly \eqn{j}
    times in the initial sample. The first column must be sorted in an
    ascending order.
}
\author{
  Chao Deng
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
## load library
library(preseqR)
## construct a RNG
f <- function(n) {
  rgamma(n, shape=0.5, scale=1)
}
## sample 10,000 individuals
preseqR.simu.hist(L=1e5, N=10000, f)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ simulation, sampling, mixture of Poisson}
