% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_next_item.R
\name{prereg_next_item}
\alias{prereg_next_item}
\title{Show the next item to specify content for}
\usage{
prereg_next_item(x, nrOfItems = 1, section = NULL)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{nrOfItems}{The number of items to complete to show.}

\item{section}{The section(s) to search; pass \code{NULL} (the default) to show
everything.}
}
\value{
x, invisibly
}
\description{
This function shows the next item (or items) in a (pre)registration
for which to specify content (searching through all sections or through
a selection of sections).
}
\examples{
### Load an example (pre)registration specification
data("examplePrereg_1", package = "preregr");

### Check next item
examplePrereg_1 |>
  preregr::prereg_next_item();

### Specify content for this item
examplePrereg_1 <-
  preregr::prereg_specify(
    examplePrereg_1,
    funding = paste0(
      "No funding. There's never any ",
      "funding for this kind of stuff."
    )
  );

### Get the next three items
preregr::prereg_next_item(
  examplePrereg_1,
  nrOfItems = 3
);

}
