% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{plot.ppgam}
\alias{plot.ppgam}
\title{Plots smooths of a fitted \code{ppgam} object}
\usage{
\method{plot}{ppgam}(x, ...)
}
\arguments{
\item{x}{a fitted \code{ppgam} object}

\item{...}{arguments to be passed to \code{mgcv::plot.gam}}
}
\value{
Simulations of parameters
}
\description{
Plots smooths of a fitted \code{ppgam} object
}
\examples{

# Times of landfalling US hurricanes
data(USlandfall)

# convert dates to years, as a continuous variable
year <- as.integer(format(USlandfall$date, "\%Y"))
day <- as.integer(format(USlandfall$date, "\%j"))
USlandfall$year <- year + pmin(day / 365, 1)
hits <- subset(USlandfall, landfall == 1)

# this creates nodes in the default way
m1 <- ppgam( ~ s(year), hits)
plot(m1)

}
\seealso{
\link[mgcv]{plot.gam}
}
