% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmpp_event_state.R
\name{mmpp_event_state}
\alias{mmpp_event_state}
\title{Estimate the latent state for events of an MMPP}
\usage{
mmpp_event_state(params = list(lambda0, c, Q), events, start = 0)
}
\arguments{
\item{params}{the parameters of the chosen MMPP}

\item{events}{the event times}

\item{start}{the start of observation}
}
\value{
probability of being in state 1 (active state) at each event,
along with most likely state
}
\description{
Given a MMPP object and events from that MMPP, infer the
most likely state of the Markov Process at each event time, along
with the probability of being in the active state.
}
\examples{
Q <- matrix(c(-0.4, 0.4, 0.2, -0.2), ncol = 2, byrow = TRUE)
mmpp_obj <- pp_mmpp(Q,
  delta = c(1 / 3, 2 / 3), lambda0 = 0.9,
  c = 1.1
)
## evaluate at some fake event times
ppdiag:::mmpp_event_state(params = mmpp_obj, events = c(1, 2, 3, 5))
}
\keyword{internal}
